/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.tools;

import com.sap.cloud.mt.tools.PollingResponse;
import com.sap.cloud.mt.tools.Wait;
import java.time.Duration;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AsyncPolling {
    private final Duration delay;
    private final Duration period;
    private final Duration maximumRuntime;
    private final ConcurrentHashMap<UUID, ScheduledFuture<?>> futures = new ConcurrentHashMap();

    private AsyncPolling(Duration delay, Duration period, Duration maximumRuntime) {
        this.delay = delay;
        this.period = period;
        this.maximumRuntime = maximumRuntime;
    }

    public <T> void execute(Supplier<PollingResponse<T>> action, Consumer<PollingResponse<T>> finalAction) {
        PollingResponse pollingResponse = new PollingResponse();
        UUID futureUuid = UUID.randomUUID();
        TimerTask task = this.createNewTask(action, finalAction, pollingResponse, futureUuid);
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        this.futures.put(futureUuid, executorService.scheduleAtFixedRate(task, this.delay.toNanos(), this.period.toNanos(), TimeUnit.NANOSECONDS));
    }

    private <T> TimerTask createNewTask(final Supplier<PollingResponse<T>> action, final Consumer<PollingResponse<T>> finalAction, final PollingResponse<T> pollingResponse, final UUID futureUuid) {
        final long startTime = System.currentTimeMillis();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                pollingResponse.copyFrom((PollingResponse)action.get());
                if (pollingResponse.isFinished() || System.currentTimeMillis() - startTime >= AsyncPolling.this.maximumRuntime.toMillis()) {
                    if (finalAction != null) {
                        finalAction.accept(pollingResponse);
                    }
                    Wait wait = Wait.createBuilder().waitTime(Duration.ofMillis(1L)).maximumTime(Duration.ofMillis(1000L)).build();
                    wait.waitUntil(() -> AsyncPolling.this.futures.contains(futureUuid));
                    ScheduledFuture future = (ScheduledFuture)AsyncPolling.this.futures.get(futureUuid);
                    AsyncPolling.this.futures.remove(futureUuid);
                    future.cancel(false);
                }
            }
        };
        return task;
    }

    public static AsyncPollingBuilder createBuilder() {
        return AsyncPollingBuilder.create();
    }

    public static final class AsyncPollingBuilder {
        private Duration delay;
        private Duration period;
        private Duration maximumRuntime;

        private static AsyncPollingBuilder create() {
            return new AsyncPollingBuilder();
        }

        public AsyncPollingBuilder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public AsyncPollingBuilder period(Duration period) {
            this.period = period;
            return this;
        }

        public AsyncPollingBuilder maximumRuntime(Duration maximumRuntime) {
            this.maximumRuntime = maximumRuntime;
            return this;
        }

        public AsyncPolling build() {
            return new AsyncPolling(this.delay, this.period, this.maximumRuntime);
        }
    }
}

