/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.HashMap;

public class HanaEncryptionTool {
    private HanaEncryptionTool() {
    }

    public static void addEncryptionParameter(InstanceCreationOptions instanceCreationOptions, DbEncryptionMode encryptionMode, String globalAccountId, String subAccountId, String applicationName) throws InternalError {
        if (encryptionMode == null) {
            return;
        }
        if (instanceCreationOptions == null) {
            throw new InternalError("Instance create options is initial");
        }
        HashMap<String, Object> parameters = instanceCreationOptions.getProvisioningParameters();
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        HashMap<String, String> dataEncryption = new HashMap<String, String>();
        dataEncryption.put("mode", encryptionMode.getValue());
        parameters.put("dataEncryption", dataEncryption);
        HashMap<String, String> subscriptionContext = new HashMap<String, String>();
        subscriptionContext.put("globalAccountID", globalAccountId);
        subscriptionContext.put("subAccountID", subAccountId);
        subscriptionContext.put("applicationName", applicationName);
        parameters.put("subscriptionContext", subscriptionContext);
        parameters.put("enableTenant", "true");
        instanceCreationOptions.withProvisioningParameters(parameters);
    }

    public static enum DbEncryptionMode {
        DEDICATED_KEY("DEDICATED_KEY"),
        MANAGED_KEY("MANAGED_KEY"),
        AUTO_DETECT("AUTO_DETECT");

        private final String value;

        private DbEncryptionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

