/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface InstanceLifecycleManager {
    public static final String DATABASE_ID = "database_id";

    public void createNewInstance(String var1, InstanceCreationOptions var2) throws InternalError;

    public void deleteInstance(String var1) throws InternalError;

    public DataSourceInfo getDataSourceInfo(String var1, boolean var2) throws InternalError, UnknownTenant;

    public ContainerStatus getContainerStatus(String var1) throws InternalError;

    public Map<String, TenantMetadata> getAllTenantInfos(boolean var1) throws InternalError;

    default public Set<String> getAllTenants(boolean forceCacheUpdate) throws InternalError {
        return this.getAllTenantInfos(forceCacheUpdate).keySet();
    }

    public void checkThatTenantExists(String var1) throws UnknownTenant, InternalError;

    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo var1) throws InternalError;

    public List<DataSourceInfo> getLibContainers() throws InternalError;

    default public String getMtLibContainerName(String databaseId) {
        return "MT_LIB_TENANT-" + databaseId;
    }

    default public InstanceCreationOptions createInstanceCreationOptions(String databaseId) {
        InstanceCreationOptions instanceCreationOptions = new InstanceCreationOptions();
        HashMap<String, String> provisioningParameters = new HashMap<String, String>();
        provisioningParameters.put(DATABASE_ID, databaseId);
        instanceCreationOptions.withProvisioningParameters(provisioningParameters);
        return instanceCreationOptions;
    }

    public boolean hasDbIdentifiers();

    public void insertDbIdentifiers(DbIdentifiers var1);

    default public DbIdentifiers.DB getDbType() {
        return DbIdentifiers.DB.HANA;
    }

    public static enum ContainerStatus {
        OK("ok"),
        IN_PROGRESS("in progress"),
        ERRONEOUS("erroneous"),
        DOES_NOT_EXIST("doesn't exist"),
        CREATION_ERROR("creation error");

        private String status;

        private ContainerStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

