/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.cloud.mt.tools.api.UuidChecker;
import com.sap.xsa.core.instancemanager.client.GetOptions;
import com.sap.xsa.core.instancemanager.client.ImClientException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import com.sap.xsa.core.instancemanager.client.ManagedServiceInstance;
import com.sap.xsa.core.instancemanager.client.OperationStatus;
import com.sap.xsa.core.instancemanager.client.ServiceBinding;
import com.sap.xsa.core.instancemanager.client.ServiceManagerClient;
import com.sap.xsa.core.instancemanager.client.impl.servicemanager.ServiceManagerClientImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerImpl
implements InstanceLifecycleManager {
    private static final Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerImpl.class);
    private static final String HOST = "host";
    private static final GetOptions NO_NEW_SERVICE_BINDINGS;
    private static final GetOptions FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS;
    private static final GetOptions PURE_CACHE_ACCESS;
    private final ServiceManagerClient serviceManagerClient;
    private final int timeout;
    private static BooleanSupplier blockRefresh;
    private final DbIdentifiersProxy dbIdentifiersProxy = new DbIdentifiersProxy();
    private final AtomicBoolean isPlanDefaultSet = new AtomicBoolean(false);

    public InstanceLifecycleManagerImpl(ServiceManagerClient serviceManagerClient, int timeout, DbIdentifiersHana dbIdentifiers, Duration smCacheRefreshInterval) {
        this.serviceManagerClient = serviceManagerClient;
        this.timeout = timeout;
        if (dbIdentifiers != null) {
            dbIdentifiers.getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
        }
        this.startRefreshScheduler(smCacheRefreshInterval);
    }

    private void startRefreshScheduler(Duration smCacheRefreshInterval) {
        if (smCacheRefreshInterval == null || smCacheRefreshInterval.isZero()) {
            logger.debug("Service Manager cache refresher isn't started");
            return;
        }
        logger.debug("Service Manager cache refresher is started with interval {}", (Object)smCacheRefreshInterval.toMinutes());
        TimerTask refreshSmClientCache = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!blockRefresh.getAsBoolean()) {
                        logger.debug("Read all managed instances into instance manager client lib cache");
                        List instances = InstanceLifecycleManagerImpl.this.serviceManagerClient.getManagedInstances(FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS);
                        if (logger.isTraceEnabled() && (instances == null || instances.isEmpty())) {
                            logger.debug("Service Manager didn't return service instances");
                        }
                    }
                }
                catch (ImClientException e) {
                    logger.error("Could not access Service Manager", (Throwable)e);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
        executor.scheduleAtFixedRate(refreshSmClientCache, 0L, smCacheRefreshInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void createNewInstance(String tenantId, InstanceCreationOptions instanceCreationOptions) throws InternalError {
        String databaseId;
        if (instanceCreationOptions != null && instanceCreationOptions.getProvisioningParameters() != null && (databaseId = (String)instanceCreationOptions.getProvisioningParameters().get("database_id")) != null) {
            logger.debug("Using database id {}", (Object)databaseId);
        }
        try {
            this.serviceManagerClient.createManagedInstance(tenantId, instanceCreationOptions, this.timeout);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        try {
            this.checkThatTenantExists(tenantId);
        }
        catch (UnknownTenant unknownTenant) {
            logger.warn("No HDI container for tenant {} found", (Object)tenantId);
            return;
        }
        try {
            this.serviceManagerClient.deleteManagedInstance(tenantId, this.timeout);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        try {
            return this.getDataSourceInfoInternal(tenantId, forceCacheUpdate);
        }
        catch (InternalError | UnknownTenant e) {
            if (forceCacheUpdate) {
                throw e;
            }
            return this.getDataSourceInfoInternal(tenantId, true);
        }
    }

    protected DataSourceInfo getDataSourceInfoInternal(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        ManagedServiceInstance instance = null;
        try {
            GetOptions getOptions = new GetOptions();
            getOptions.setForceCacheUpdate(forceCacheUpdate);
            getOptions.setCreateBindingIfMissing(false);
            instance = this.serviceManagerClient.getManagedInstance(tenantId, getOptions);
            if (instance == null) {
                throw new UnknownTenant("Tenant [" + tenantId + "] is not known");
            }
        }
        catch (ImClientException e) {
            throw new UnknownTenant(e, "Tenant [" + tenantId + "] is not known");
        }
        ServiceBinding binding = instance.getBinding();
        if (binding == null || binding.getCredentials() == null || !binding.isReady()) {
            logger.error("Database container service instance for tenant {} doesn't have a ready binding", (Object)tenantId);
            throw new InternalError(String.format("Database container service instance for tenant %s doesn't have a ready binding", tenantId));
        }
        Map credentials = binding.getCredentials();
        String statusText = OperationStatus.CREATION_SUCCEEDED.toString();
        return DataSourceInfoBuilder.createBuilder().host((String)credentials.get(HOST)).port((String)credentials.get("port")).driver((String)credentials.get("driver")).url((String)credentials.get("url")).schema((String)credentials.get("schema")).hdiUser((String)credentials.get("hdi_user")).hdiPassword((String)credentials.get("hdi_password")).user((String)credentials.get("user")).password((String)credentials.get("password")).certificate((String)credentials.get("certificate")).tenantId(tenantId).id(instance.getId()).statusAsText(statusText).dbKey(this.createDbKey((String)credentials.get(HOST), (String)credentials.get("port"))).databaseId(this.getDatabaseId(credentials)).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        try {
            ManagedServiceInstance instance = this.serviceManagerClient.getManagedInstance(tenantId, FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS);
            if (instance == null) {
                return InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST;
            }
            OperationStatus status = instance.getStatus();
            return this.getContainerStatus(status);
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
    }

    private InstanceLifecycleManager.ContainerStatus getContainerStatus(OperationStatus status) throws InternalError {
        switch (status) {
            case CREATION_SUCCEEDED: 
            case UPDATE_SUCCEEDED: 
            case UPDATE_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.OK;
            }
            case CREATION_IN_PROGRESS: 
            case UPDATE_IN_PROGRESS: 
            case DELETION_IN_PROGRESS: {
                return InstanceLifecycleManager.ContainerStatus.IN_PROGRESS;
            }
            case DELETION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.ERRONEOUS;
            }
            case CREATION_FAILED: {
                return InstanceLifecycleManager.ContainerStatus.CREATION_ERROR;
            }
        }
        logger.error("Undefined status {}", (Object)status);
        throw new InternalError("Unknown status");
    }

    @Override
    public Map<String, TenantMetadata> getAllTenantInfos(boolean forceCacheUpdate) throws InternalError {
        List instances = null;
        try {
            if (forceCacheUpdate) {
                instances = this.serviceManagerClient.getManagedInstances(FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS);
            } else {
                this.setDefaultPlanInSM();
                instances = this.serviceManagerClient.getManagedInstances(PURE_CACHE_ACCESS);
            }
        }
        catch (ImClientException e) {
            throw new InternalError(e);
        }
        if (instances == null) {
            return new HashMap<String, TenantMetadata>();
        }
        return instances.stream().filter(i -> {
            try {
                return this.getContainerStatus(i.getStatus()) == InstanceLifecycleManager.ContainerStatus.OK;
            }
            catch (InternalError internalError) {
                return false;
            }
        }).map(instance -> {
            TenantMetadata tenantInfo = new TenantMetadata(instance.getId());
            String dbId = this.getDatabaseId(instance.getCredentials());
            if (dbId != null) {
                tenantInfo.putAdditionalProperty("database_id", dbId);
            }
            return tenantInfo;
        }).filter(tenantInfo -> FilterTenants.realTenants().test(tenantInfo.getTenantId())).collect(Collectors.toMap(TenantMetadata::getTenantId, Function.identity()));
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant, InternalError {
        try {
            ManagedServiceInstance instance = this.serviceManagerClient.getManagedInstance(tenantId, FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS);
            if (instance == null) {
                throw new UnknownTenant("Tenant " + tenantId + " is not known");
            }
        }
        catch (ImClientException e) {
            throw new InternalError("Instance manager client lib reports an error", e);
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) throws InternalError {
        String databaseId = null;
        if (dataSourceInfo != null) {
            databaseId = dataSourceInfo.getDatabaseId();
        }
        Set<String> missingLibContainersDbIds = new HashSet<String>();
        if (databaseId != null) {
            if (this.isLibContainerMissing(databaseId)) {
                missingLibContainersDbIds.add(databaseId);
            }
        } else {
            missingLibContainersDbIds = this.getMissingLibContainers(this.dbIdentifiersProxy.getDbIds());
        }
        missingLibContainersDbIds.stream().forEach(id -> {
            try {
                logger.debug("Create new mt-lib container for database {}", id);
                this.createNewInstance(this.getMtLibContainerName((String)id), this.createInstanceCreationOptions((String)id));
            }
            catch (InternalError internalError) {
                logger.debug("Could not create new mt-lib container for database {} because of {} ", id, (Object)internalError.getMessage());
            }
        });
        return this.getLibContainers();
    }

    @Override
    public List<DataSourceInfo> getLibContainers() {
        ArrayList<DataSourceInfo> dsInfo = new ArrayList<DataSourceInfo>();
        this.dbIdentifiersProxy.getDbIds().stream().forEach(id -> {
            try {
                dsInfo.add(this.getDataSourceInfo(this.getMtLibContainerName((String)id), false));
            }
            catch (InternalError | UnknownTenant exception) {
                // empty catch block
            }
        });
        return dsInfo;
    }

    private Set<String> getMissingLibContainers(Set<String> dbIds) {
        return dbIds.stream().filter(this::isLibContainerMissing).collect(Collectors.toSet());
    }

    private boolean isLibContainerMissing(String dbId) {
        try {
            return this.serviceManagerClient.getManagedInstance(this.getMtLibContainerName(dbId), NO_NEW_SERVICE_BINDINGS) == null;
        }
        catch (ImClientException e) {
            return true;
        }
    }

    private DbIdentifiers getDbIdentifiers() {
        return this.dbIdentifiersProxy.createCopy();
    }

    @Override
    public boolean hasDbIdentifiers() {
        return this.dbIdentifiersProxy.areSet();
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
        ((DbIdentifiersHana)dbIdentifiers).getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return this.dbIdentifiersProxy.getDbType();
    }

    private String createDbKey(String host, String port) {
        return host + ":" + port;
    }

    private String getDatabaseId(Map<String, Object> credentials) {
        String databaseId = (String)credentials.get("database_id");
        if (StringUtils.isNotEmpty((CharSequence)databaseId)) {
            return databaseId;
        }
        databaseId = StringUtils.substringBefore((String)((String)credentials.get(HOST)), (String)".");
        return UuidChecker.isUUId((String)databaseId) ? databaseId : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultPlanInSM() throws ImClientException {
        InstanceLifecycleManagerImpl instanceLifecycleManagerImpl = this;
        synchronized (instanceLifecycleManagerImpl) {
            if (!this.isPlanDefaultSet.get()) {
                ((ServiceManagerClientImpl)this.serviceManagerClient).setDefaultManagedServicePlan();
                this.isPlanDefaultSet.set(true);
            }
        }
    }

    public static void setBlockRefresh(BooleanSupplier blockRefresh) {
        InstanceLifecycleManagerImpl.blockRefresh = blockRefresh;
    }

    static {
        blockRefresh = () -> false;
        NO_NEW_SERVICE_BINDINGS = new GetOptions();
        NO_NEW_SERVICE_BINDINGS.setCreateBindingIfMissing(false);
        FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS = new GetOptions();
        FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS.setCreateBindingIfMissing(false);
        FORCE_CACHE_UPDATE_NO_NEW_SERVICE_BINDINGS.setForceCacheUpdate(true);
        PURE_CACHE_ACCESS = new GetOptions();
        PURE_CACHE_ACCESS.setCreateBindingIfMissing(false);
        PURE_CACHE_ACCESS.setPureCacheAccess(true);
    }

    private class DbIdentifiersProxy {
        private final DbIdentifiersHana dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());

        private DbIdentifiersProxy() {
        }

        public void add(String dbId) {
            this.dbIdentifiers.add(dbId);
        }

        public DbIdentifiers.DB getDbType() {
            return this.dbIdentifiers.getDB();
        }

        public boolean areSet() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.areSet();
        }

        public DbIdentifiers createCopy() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.createCopy();
        }

        public Set<String> getDbIds() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.getDbIds();
        }

        private synchronized void updateDbIdentifiers() {
            try {
                List instances = InstanceLifecycleManagerImpl.this.serviceManagerClient.getManagedInstances(PURE_CACHE_ACCESS);
                if (instances != null) {
                    instances.stream().map(ManagedServiceInstance::getCredentials).filter(Objects::nonNull).map(InstanceLifecycleManagerImpl.this::getDatabaseId).filter(Objects::nonNull).map(Object::toString).forEach(this::add);
                }
            }
            catch (ImClientException imClientException) {
                // empty catch block
            }
        }
    }
}

