/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.mt.subscription.HanaEncryptionTool;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.AsyncCallResult;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxTools {
    public static final Duration SAAS_REGISTRY_WAIT_TIME = Duration.ofMillis(20L);
    private static final String X_JOB_ID = "x-job-id";
    private static final String LOCATION = "Location";
    private static final String PREFIX_FOR_NEW_JOB_ENDPOINT = "jobId-";
    private static Logger logger = LoggerFactory.getLogger(MtxTools.class);
    private static final String STATUS = "status";
    private static final String JOB_ID = "jobID";
    private final SecurityChecker securityChecker;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final PollingParameters pollingParameter;
    private final HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;

    public MtxTools(SecurityChecker securityChecker, String baseUiUrl, String urlSeparator, PollingParameters pollingParameter, HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) {
        this.securityChecker = securityChecker;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.pollingParameter = pollingParameter;
        this.hanaEncryptionMode = hanaEncryptionMode;
    }

    public static AsyncCallResult waitForCompletion(String jobId, StatusProvider statusProvider, PollingParameters pollingParameter) {
        Instant start = Instant.now();
        while (true) {
            logger.debug("Wait for completion of job {}", (Object)jobId);
            try {
                Map<String, Object> result = statusProvider.getStatus(jobId);
                if (!result.containsKey(STATUS)) {
                    logger.debug("Mtx returned no status for job {}", (Object)jobId);
                    return new AsyncCallResult((Exception)new InternalError("Mtx returned no status for job " + jobId));
                }
                logger.debug("Mtx returned status {} for job {}", result.get(STATUS), (Object)jobId);
                switch (((String)result.get(STATUS)).toUpperCase(Locale.ENGLISH)) {
                    case "FINISHED": {
                        return AsyncCallResult.createOk();
                    }
                    case "INITIAL": 
                    case "QUEUED": 
                    case "RUNNING": 
                    case "PROCESSING": {
                        break;
                    }
                    case "FAILED": {
                        return new AsyncCallResult((Exception)new InternalError("Provisioning service returned with status \"failed\""));
                    }
                    default: {
                        return new AsyncCallResult((Exception)new InternalError("Unexpected status" + (String)result.get(STATUS)));
                    }
                }
            }
            catch (Exception e) {
                return new AsyncCallResult(e);
            }
            if (Duration.between(start, Instant.now()).compareTo(pollingParameter.getRequestTimeout()) >= 0) {
                logger.error("Maximum waiting time for job {} exceeded", (Object)jobId);
                return new AsyncCallResult((Exception)new InternalError("Maximum waiting time on called service exceeded"));
            }
            Tools.waitSomeTime(pollingParameter.getInterval());
        }
    }

    public static String extractJobId(ServiceResponse<String> response) throws InternalException {
        String jobId = null;
        if (response.getHeaders() != null) {
            jobId = MtxTools.getFromHeader(response, X_JOB_ID);
            if (StringUtils.isNotBlank((CharSequence)jobId)) {
                return MtxTools.wrap(jobId);
            }
            String location = MtxTools.getFromHeader(response, LOCATION);
            String[] parts = location.split("/jobs/");
            if (parts.length == 2 && StringUtils.isNotBlank((CharSequence)(jobId = parts[1]))) {
                return jobId;
            }
        }
        if (StringUtils.isBlank((CharSequence)(jobId = (String)MtxTools.getResponseAsMap(response).get(JOB_ID)))) {
            throw new InternalException("No job id returned");
        }
        logger.debug("Returned jobId is {}", (Object)jobId);
        return jobId;
    }

    public static String wrap(String jobId) {
        return PREFIX_FOR_NEW_JOB_ENDPOINT + jobId;
    }

    public static boolean isJobForNewEndpoint(String jobId) {
        return jobId.startsWith(PREFIX_FOR_NEW_JOB_ENDPOINT);
    }

    public static String unWrapJobId(String jobId) {
        if (MtxTools.isJobForNewEndpoint(jobId)) {
            return jobId.substring(PREFIX_FOR_NEW_JOB_ENDPOINT.length());
        }
        return jobId;
    }

    private static String getFromHeader(ServiceResponse<String> response, String fieldName) {
        return Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase(fieldName)).map(NameValuePair::getValue).findFirst().orElse("");
    }

    private static Map<String, Object> getResponseAsMap(ServiceResponse<String> response) throws InternalException {
        if (response.getPayload().isPresent()) {
            try {
                return (Map)new Gson().fromJson((String)response.getPayload().get(), Map.class);
            }
            catch (JsonSyntaxException e) {
                throw new InternalException("No map returned from mtx service", (Throwable)e);
            }
        }
        return new HashMap<String, Object>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String tenantId, UnSubscribeExecutor unsubscribeExecutor, StatusProvider statusProvider, DeletePayload deletePayload, boolean withoutAuthorityCheck, Exits exits) throws InternalError, ParameterError, AuthorityError {
        if (!withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        boolean isUnsubscribePossible = Boolean.TRUE.equals(exits.getBeforeUnSubscribeMethod().call(tenantId, deletePayload));
        if (isUnsubscribePossible) {
            String jobId = unsubscribeExecutor.execute();
            AsyncCallResult asyncCallResult = MtxTools.waitForCompletion(jobId, statusProvider, this.pollingParameter);
            if (!asyncCallResult.isOk()) throw new InternalError(asyncCallResult.getException());
            exits.getAfterUnSubscribeMethod().call(tenantId, deletePayload);
            return;
        } else {
            logger.debug("Unsubscribe exit returned false => skipped unsubscribe for tenant {}", (Object)tenantId);
        }
    }

    public String subscribe(String tenantId, SubscribeExecutor subscribeExecutor, StatusProvider statusProvider, SubscriptionPayload subscriptionPayload, boolean withoutAuthorityCheck, Exits exits) throws InternalError, ParameterError, AuthorityError {
        String jobId;
        if (!withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        InstanceCreationOptions instanceCreationOptions = exits.getBeforeSubscribeMethod().call(tenantId, subscriptionPayload);
        if (instanceCreationOptions == null) {
            instanceCreationOptions = new InstanceCreationOptions();
        }
        HanaEncryptionTool.addEncryptionParameter(instanceCreationOptions, this.hanaEncryptionMode, subscriptionPayload.globalAccountGUID, subscriptionPayload.subscribedSubaccountId, subscriptionPayload.subscriptionAppName);
        String applicationUrl = Tools.getApplicationUrl(subscriptionPayload, exits.getSubscribeExit()::uiURL, exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
        try {
            jobId = subscribeExecutor.execute(instanceCreationOptions);
        }
        catch (InternalError e) {
            exits.getAfterSubscribeMethod().call(tenantId, subscriptionPayload, false);
            throw e;
        }
        AsyncCallResult asyncCallResult = MtxTools.waitForCompletion(jobId, statusProvider, this.pollingParameter);
        exits.getAfterSubscribeMethod().call(tenantId, subscriptionPayload, asyncCallResult.isOk());
        if (asyncCallResult.isNotOk()) {
            throw new InternalError(asyncCallResult.getException());
        }
        return applicationUrl;
    }

    @FunctionalInterface
    public static interface StatusProvider {
        public Map<String, Object> getStatus(String var1) throws InternalError, NotFound;
    }

    @FunctionalInterface
    public static interface UnSubscribeExecutor {
        public String execute() throws InternalError;
    }

    @FunctionalInterface
    public static interface SubscribeExecutor {
        public String execute(InstanceCreationOptions var1) throws InternalError;
    }

    @FunctionalInterface
    public static interface SupplierWithInternalError<T> {
        public T get() throws InternalError;
    }

    @FunctionalInterface
    public static interface SaasRegistryCaller {
        public void callSaasRegistry(boolean var1, String var2, String var3) throws InternalError;
    }
}

