/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.ServiceSpecification;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SidecarAccess {
    public static final String MTX_SIDECAR_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final String SIDECAR_SUBSCRIBE_ENDPOINT = "/mtx/v1/internal/provisioning/subscribe";
    private static final String SIDECAR_UNSUBSCRIBE_ENDPOINT = "/mtx/v1/internal/provisioning/unsubscribe";
    private static final String SIDECAR_UPGRADE_ENDPOINT = "/mtx/v1/model/asyncUpgrade";
    private static final String SIDECAR_STATUS_ENDPOINT = "/mtx/v1/model/status/";
    private static final String UNEXPECTED_RETURN_CODE = "Unexpected return code ";
    private final ServiceEndpoint upgradeEndpoint;
    private final ServiceEndpoint getStatusEndpoint;
    private final ServiceEndpoint subscribeEndpoint;
    private final ServiceEndpoint unsubscribeEndpoint;
    private final ServiceSpecification serviceSpecification;

    public SidecarAccess(ServiceSpecification serviceSpecification) throws InternalError {
        this.serviceSpecification = serviceSpecification;
        HashSet<Integer> retryCodes = new HashSet<Integer>();
        retryCodes.add(502);
        retryCodes.add(504);
        retryCodes.add(500);
        retryCodes.add(503);
        retryCodes.add(404);
        try {
            this.upgradeEndpoint = ServiceEndpoint.create().destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_UPGRADE_ENDPOINT).returnCodeChecker(c -> {
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.getStatusEndpoint = ServiceEndpoint.create().destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_STATUS_ENDPOINT).returnCodeChecker(c -> {
                if (c == 404) {
                    return new NotFound("Job id not known");
                }
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.subscribeEndpoint = ServiceEndpoint.create().destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_SUBSCRIBE_ENDPOINT).returnCodeChecker(c -> {
                if (c != 201 && c != 200 && c != 202) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.unsubscribeEndpoint = ServiceEndpoint.create().destinationName(MTX_SIDECAR_DESTINATION).path(SIDECAR_UNSUBSCRIBE_ENDPOINT).returnCodeChecker(c -> {
                if (c != 202 && c != 204) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(retryCodes).config(serviceSpecification.getResilienceConfig()).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public String callSidecarUpgrade(SidecarUpgradePayload upgradePayload) throws InternalError {
        try {
            ServiceCall upgrade = this.upgradeEndpoint.createServiceCall().http().post().payload((Object)upgradePayload).noPathParameter().noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            ServiceResponse response = upgrade.execute(String.class);
            return response.getPayload().orElse("");
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public Map<String, Object> callSidecarStatus(String jobId) throws InternalError, NotFound {
        try {
            ServiceCall getStatus = this.getStatusEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(jobId).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            ServiceResponse response = getStatus.execute(Map.class);
            if (response.getHttpStatusCode() == 404) {
                throw new NotFound("Job id not known");
            }
            return response.getPayload().orElse(new HashMap());
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            if (e.getCause() instanceof NotFound) {
                throw (NotFound)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public String callSidecarSubscribe(String tenantId, String jwt, SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) throws InternalError {
        Map payload = (Map)new ObjectMapper().convertValue((Object)Tools.getSubscriptionPayloadForSidecar(subscriptionPayload, instanceCreationOptions, false), Map.class);
        payload.put("subscribedTenantId", tenantId);
        payload.put("async", true);
        try {
            ServiceCall subscribe = this.subscribeEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().noQuery().enhancer(request -> request.addHeader("Authorization", jwt)).end();
            return MtxTools.extractJobId((ServiceResponse<String>)subscribe.execute(String.class));
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public String callSidecarUnsubscribe(String tenantId, String jwt, DeletePayload deletePayloadCopy) throws InternalError {
        Map payload = (Map)new ObjectMapper().convertValue((Object)new SidecarUnSubscriptionPayload(deletePayloadCopy), Map.class);
        payload.put("subscribedTenantId", tenantId);
        payload.put("async", true);
        try {
            ServiceCall unsubscribe = this.unsubscribeEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().noQuery().enhancer(request -> request.addHeader("Authorization", jwt)).end();
            return MtxTools.extractJobId((ServiceResponse<String>)unsubscribe.execute(String.class));
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            if (e.getCause() instanceof InternalError) {
                throw (InternalError)e.getCause();
            }
            throw new InternalError(e);
        }
    }

    public ServiceSpecification getServiceSpecification() {
        return this.serviceSpecification;
    }
}

