/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.HanaEncryptionTool;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.SidecarAccess;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberSidecarImpl
implements Subscriber {
    private static final Logger logger = LoggerFactory.getLogger(SubscriberSidecarImpl.class);
    private final Exits exits;
    private final SecurityChecker securityChecker;
    private final SaasRegistry saasRegistry;
    private final SidecarAccess sidecarAccess;
    private final MtxTools mtxTools;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final boolean withoutAuthorityCheck;

    private SubscriberSidecarImpl(String baseUiUrl, String urlSeparator, Exits exits, SecurityChecker securityChecker, SaasRegistry saasRegistry, SidecarAccess sidecarAccess, boolean withoutAuthorityCheck, HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) throws InternalError {
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.exits = exits;
        this.saasRegistry = saasRegistry;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.sidecarAccess = sidecarAccess;
        this.mtxTools = new MtxTools(securityChecker, baseUiUrl, urlSeparator, sidecarAccess.getServiceSpecification().getPolling() != null ? sidecarAccess.getServiceSpecification().getPolling() : PollingParameters.Builder.create().timeout(Duration.ofHours(1L)).build(), hanaEncryptionMode);
        this.withoutAuthorityCheck = withoutAuthorityCheck;
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        this.mtxTools.unsubscribe(tenantId, () -> this.sidecarAccess.callSidecarUnsubscribe(tenantId, jwt, deletePayload), jobId -> this.sidecarAccess.callSidecarStatus(jobId), deletePayload, this.withoutAuthorityCheck, this.exits);
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies() throws AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return this.exits.getDependencyExit() != null ? this.exits.getDependencyExit().onGetDependencies() : new ArrayList();
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, String jwt) throws InternalError, ParameterError, AuthorityError {
        return this.mtxTools.subscribe(tenantId, instanceCreationOptions -> this.sidecarAccess.callSidecarSubscribe(tenantId, jwt, subscriptionPayload, instanceCreationOptions), jobId -> this.sidecarAccess.callSidecarStatus(jobId), subscriptionPayload, this.withoutAuthorityCheck, this.exits);
    }

    @Override
    public String getSubscribeUrl(SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return Tools.getApplicationUrl(subscriptionPayload, this.exits.getSubscribeExit()::uiURL, this.exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
    }

    @Override
    public void setupDbTables(List<String> tenants) throws InternalError, NotSupported, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        logger.debug("Synchronous init db is not supported with sidecar");
        throw new NotSupported("Synchronous init db is not supported with sidecar");
    }

    @Override
    public String setupDbTablesAsync(List<String> tenants) throws InternalError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        SidecarUpgradePayload upgradePayload = new SidecarUpgradePayload();
        upgradePayload.tenants = tenants.toArray(new String[tenants.size()]);
        return this.sidecarAccess.callSidecarUpgrade(upgradePayload);
    }

    @Override
    public String updateStatus(String jobId) throws InternalError, ParameterError, NotFound, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        if (StringUtils.isBlank((CharSequence)jobId)) {
            logger.warn("An empty jobId was provided");
            return "{}";
        }
        if (!jobId.matches("^[_a-zA-Z0-9\\-]+$")) {
            throw new ParameterError("Job id contains illegal characters");
        }
        Map<String, Object> resultMap = this.sidecarAccess.callSidecarStatus(jobId);
        try {
            return new ObjectMapper().writeValueAsString(resultMap);
        }
        catch (JsonProcessingException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void callSaasRegistry(boolean ok, String message, String applicationUrl, String saasRegistryUrl) throws InternalError {
        this.saasRegistry.callBackSaasRegistry(ok, message, applicationUrl, saasRegistryUrl);
    }

    @Override
    public void checkAuthority(SecurityChecker.Authority authority) throws AuthorityError {
        this.securityChecker.checkAuthority(authority);
    }

    public static final class SubscriberSidecarImplBuilder {
        private Exits exits;
        private String baseUiUrl;
        private String urlSeparator;
        private SecurityChecker securityChecker;
        private SaasRegistry saasRegistry;
        private SidecarAccess sidecarAccess;
        private boolean withoutAuthorityCheck;
        private HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;

        private SubscriberSidecarImplBuilder() {
        }

        public static SubscriberSidecarImplBuilder create() {
            return new SubscriberSidecarImplBuilder();
        }

        public SubscriberSidecarImplBuilder exits(Exits exits) {
            this.exits = exits;
            return this;
        }

        public SubscriberSidecarImplBuilder baseUiUrl(String baseUiUrl) {
            this.baseUiUrl = baseUiUrl;
            return this;
        }

        public SubscriberSidecarImplBuilder urlSeparator(String urlSeparator) {
            this.urlSeparator = urlSeparator;
            return this;
        }

        public SubscriberSidecarImplBuilder securityChecker(SecurityChecker securityChecker) {
            this.securityChecker = securityChecker;
            return this;
        }

        public SubscriberSidecarImplBuilder saasRegistry(SaasRegistry saasRegistry) {
            this.saasRegistry = saasRegistry;
            return this;
        }

        public SubscriberSidecarImplBuilder sidecarAccess(SidecarAccess sidecarAccess) {
            this.sidecarAccess = sidecarAccess;
            return this;
        }

        public SubscriberSidecarImplBuilder withoutAuthorityCheck(boolean withoutAuthorityCheck) {
            this.withoutAuthorityCheck = withoutAuthorityCheck;
            return this;
        }

        public SubscriberSidecarImplBuilder hanaEncryptionMode(HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) {
            this.hanaEncryptionMode = hanaEncryptionMode;
            return this;
        }

        public SubscriberSidecarImpl build() throws InternalError {
            return new SubscriberSidecarImpl(this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry, this.sidecarAccess, this.withoutAuthorityCheck, this.hanaEncryptionMode);
        }
    }
}

