/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.json.ApplicationForSidecar;
import com.sap.cloud.mt.subscription.json.Cloner;
import com.sap.cloud.mt.subscription.json.ManagedHanaForSidecar;
import com.sap.cloud.mt.subscription.json.SAPForSidecar;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static final String SECURE_CHARS = "^[_a-zA-Z0-9\\-]+$";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED = "tenant successfully subscribed - no application URL provided";

    private Tools() {
    }

    public static void checkExternalTenantId(String tenantId) throws ParameterError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            throw new ParameterError("Tenant Id is identical to a technical container");
        }
        Tools.checkTenantIdCharacters(tenantId);
    }

    public static void checkExternalTenantIds(List<String> tenantIds) throws ParameterError {
        for (String tenantId : tenantIds) {
            Tools.checkExternalTenantId(tenantId);
        }
    }

    public static void checkTenantIdCharacters(String tenantId) throws ParameterError {
        if (!tenantId.matches(SECURE_CHARS)) {
            throw new ParameterError("Tenant id contains forbidden characters");
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getApplicationUrl(SubscriptionPayload subscriptionPayload, Supplier<URL> urlSupplier, Function<SubscriptionPayload, URL> urlFunction, String baseUiUrl, String urlSeparator) throws InternalError, ParameterError {
        String applicationUrl;
        if (subscriptionPayload == null || subscriptionPayload.subscribedSubdomain == null) {
            return TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        URL urlFromExit = urlSupplier.get();
        if (urlFromExit == null) {
            urlFromExit = urlFunction.apply(Cloner.clone(subscriptionPayload));
        }
        String string = applicationUrl = urlFromExit != null ? urlFromExit.toExternalForm() : null;
        if (applicationUrl == null) {
            applicationUrl = UiUrlCreator.createUrl(subscriptionPayload.subscribedSubdomain, baseUiUrl, urlSeparator);
        }
        if (StringUtils.isBlank((CharSequence)applicationUrl)) {
            applicationUrl = TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        return applicationUrl;
    }

    public static SidecarSubscriptionPayload getSubscriptionPayloadForSidecar(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions, boolean takeOverEventType) {
        SidecarSubscriptionPayload payload = new SidecarSubscriptionPayload(subscriptionPayload);
        if (takeOverEventType && StringUtils.isNotBlank((CharSequence)subscriptionPayload.eventType)) {
            payload.eventType = subscriptionPayload.eventType;
        }
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && !instanceCreationOptions.getProvisioningParameters().isEmpty()) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && !instanceCreationOptions.getBindingParameters().isEmpty()) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            payload._application_ = new ApplicationForSidecar();
            payload._application_.sap = new SAPForSidecar();
            payload._application_.sap.managedHana = new ManagedHanaForSidecar();
            if (hasProvisioningParameters) {
                payload._application_.sap.managedHana.provisioning_parameters = instanceCreationOptions.getProvisioningParameters();
            }
            if (hasBindingParameters) {
                payload._application_.sap.managedHana.binding_parameters = instanceCreationOptions.getBindingParameters();
            }
        }
        return payload;
    }
}

