/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.json.Cloner;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static final String SECURE_CHARS = "^[_a-zA-Z0-9\\-]+$";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED = "tenant successfully subscribed - no application URL provided";
    public static final String ADDITIONAL_INFO_FOR_SM = "_";
    public static final String EVENT_TYPE = "eventType";

    private Tools() {
    }

    public static void checkExternalTenantId(String tenantId) throws ParameterError {
        if (!FilterTenants.realTenants().test(tenantId)) {
            throw new ParameterError("Tenant Id is identical to a technical container");
        }
        Tools.checkTenantIdCharacters(tenantId);
    }

    public static void checkExternalTenantIds(List<String> tenantIds) throws ParameterError {
        for (String tenantId : tenantIds) {
            Tools.checkExternalTenantId(tenantId);
        }
    }

    public static void checkTenantIdCharacters(String tenantId) throws ParameterError {
        if (!tenantId.matches(SECURE_CHARS)) {
            throw new ParameterError("Tenant id contains forbidden characters");
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getApplicationUrl(SubscriptionPayload subscriptionPayload, Supplier<URL> urlSupplier, Function<SubscriptionPayload, URL> urlFunction, String baseUiUrl, String urlSeparator) throws InternalError, ParameterError {
        String applicationUrl;
        if (subscriptionPayload == null || subscriptionPayload.subscribedSubdomain == null) {
            return TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        URL urlFromExit = urlSupplier.get();
        if (urlFromExit == null) {
            urlFromExit = urlFunction.apply(Cloner.clone(subscriptionPayload));
        }
        String string = applicationUrl = urlFromExit != null ? urlFromExit.toExternalForm() : null;
        if (applicationUrl == null) {
            applicationUrl = UiUrlCreator.createUrl(subscriptionPayload.subscribedSubdomain, baseUiUrl, urlSeparator);
        }
        if (StringUtils.isBlank((CharSequence)applicationUrl)) {
            applicationUrl = TENANT_SUCCESSFULLY_SUBSCRIBED_NO_APPLICATION_URL_PROVIDED;
        }
        return applicationUrl;
    }

    public static Map<String, Object> getSubscriptionPayloadForSidecar(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.putAll(subscriptionPayload.getMap());
        if (StringUtils.isBlank((CharSequence)((String)payload.get(EVENT_TYPE)))) {
            payload.put(EVENT_TYPE, "CREATE");
        }
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && !instanceCreationOptions.getProvisioningParameters().isEmpty()) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && !instanceCreationOptions.getBindingParameters().isEmpty()) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            HashMap application = new HashMap();
            payload.put("_application_", application);
            HashMap sap = new HashMap();
            application.put("sap", sap);
            HashMap<String, Map> serviceManager = new HashMap<String, Map>();
            sap.put("service-manager", serviceManager);
            if (hasProvisioningParameters) {
                serviceManager.put("provisioning_parameters", instanceCreationOptions.getProvisioningParameters());
            }
            if (hasBindingParameters) {
                serviceManager.put("binding_parameters", instanceCreationOptions.getBindingParameters());
            }
        }
        return payload;
    }

    public static Map<String, Object> getProvisioningServicePayload(SubscriptionPayload subscriptionPayload, InstanceCreationOptions instanceCreationOptions) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.putAll(subscriptionPayload.getMap());
        boolean hasProvisioningParameters = false;
        boolean hasBindingParameters = false;
        if (instanceCreationOptions != null) {
            if (instanceCreationOptions.getProvisioningParameters() != null && !instanceCreationOptions.getProvisioningParameters().isEmpty()) {
                hasProvisioningParameters = true;
            }
            if (instanceCreationOptions.getBindingParameters() != null && !instanceCreationOptions.getBindingParameters().isEmpty()) {
                hasBindingParameters = true;
            }
        }
        if (hasProvisioningParameters || hasBindingParameters) {
            HashMap<String, Map> hdi = new HashMap<String, Map>();
            HashMap<String, HashMap<String, Map>> additionalInfoForSM = new HashMap<String, HashMap<String, Map>>();
            payload.put(ADDITIONAL_INFO_FOR_SM, additionalInfoForSM);
            additionalInfoForSM.put("hdi", hdi);
            if (hasProvisioningParameters) {
                hdi.put("create", instanceCreationOptions.getProvisioningParameters());
            }
            if (hasBindingParameters) {
                hdi.put("bind", instanceCreationOptions.getBindingParameters());
            }
        }
        return payload;
    }
}

