/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.json.UserInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenantLcmPayload {
    public String subscriptionGUID;
    public String subscriptionAppId;
    public String subscriptionAppName;
    public String subscribedTenantId;
    public String subscribedZoneId;
    public String subscribedSubdomain;
    public String subscribedCrmId;
    public String subscribedSubaccountId;
    public String subscriptionAppPlan;
    public String subscriptionAppAmount;
    public String[] dependentServiceInstanceAppIds;
    public String[] dependantServiceInstanceAppIds;
    public String globalAccountGUID;
    public String userId;
    public UserInfo userInfo;
    @JsonIgnore
    private static final Logger logger = LoggerFactory.getLogger(AbstractTenantLcmPayload.class);
    @JsonIgnore
    protected final Map<String, Object> map = new HashMap<String, Object>();
    @JsonIgnore
    protected static final ObjectMapper mapper = new ObjectMapper();

    protected AbstractTenantLcmPayload(Map<String, Object> map) {
        this.map.putAll(map);
        this.fillAttributesFromMap();
    }

    protected AbstractTenantLcmPayload() {
    }

    public Map<String, Object> getMap() {
        if (this.map.isEmpty() && this.attributesSet()) {
            this.map.putAll((Map)mapper.convertValue((Object)this, Map.class));
        }
        return this.map;
    }

    public String toString() {
        try {
            return this.getClass().getName() + mapper.writeValueAsString(this.getMap());
        }
        catch (JsonProcessingException e) {
            logger.error("Could not convert map into Json", (Throwable)e);
            return this.getClass().getName();
        }
    }

    protected void fillAttributesFromMap() {
        this.subscriptionGUID = (String)this.map.get("subscriptionGUID");
        this.subscriptionAppId = (String)this.map.get("subscriptionAppId");
        this.subscriptionAppName = (String)this.map.get("subscriptionAppName");
        this.subscribedTenantId = (String)this.map.get("subscribedTenantId");
        this.subscribedZoneId = (String)this.map.get("subscribedZoneId");
        this.subscribedSubdomain = (String)this.map.get("subscribedSubdomain");
        this.subscribedCrmId = (String)this.map.get("subscribedCrmId");
        this.subscribedSubaccountId = (String)this.map.get("subscribedSubaccountId");
        this.subscriptionAppPlan = (String)this.map.get("subscriptionAppPlan");
        this.subscriptionAppAmount = (String)this.map.get("subscriptionAppAmount");
        if (this.map.get("dependentServiceInstanceAppIds") != null) {
            this.dependentServiceInstanceAppIds = ((List)this.map.get("dependentServiceInstanceAppIds")).toArray(new String[]{""});
        }
        if (this.map.get("dependantServiceInstanceAppIds") != null) {
            this.dependantServiceInstanceAppIds = ((List)this.map.get("dependantServiceInstanceAppIds")).toArray(new String[]{""});
        }
        this.globalAccountGUID = (String)this.map.get("globalAccountGUID");
        this.userId = (String)this.map.get("userId");
        if (this.map.get("userInfo") != null) {
            Map userInfoMap = (Map)this.map.get("userInfo");
            this.userInfo = new UserInfo();
            this.userInfo.sub = (String)userInfoMap.get("sub");
            this.userInfo.email = (String)userInfoMap.get("email");
            this.userInfo.userName = (String)userInfoMap.get("userName");
            this.userInfo.subIdp = (String)userInfoMap.get("subIdp");
            this.userInfo.userId = (String)userInfoMap.get("userId");
        }
    }

    private boolean attributesSet() {
        return StringUtils.isNotBlank((CharSequence)this.subscribedSubdomain) || StringUtils.isNotBlank((CharSequence)this.globalAccountGUID) || StringUtils.isNotBlank((CharSequence)this.subscribedSubaccountId) || StringUtils.isNotBlank((CharSequence)this.subscriptionAppName) || StringUtils.isNotBlank((CharSequence)this.subscribedTenantId);
    }
}

