/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cloud.mt.subscription.BindingParameters;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.ProvisioningParameters;
import com.sap.cloud.mt.subscription.SqLiteFileResolver;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InstanceLifecycleManagerSqLite
implements InstanceLifecycleManager {
    private static final String SQLITE_CONNECTION_OPTIONS = "open_mode=2";
    private final SqLiteFileResolver sqLiteFileResolver;

    public InstanceLifecycleManagerSqLite(Path root) {
        this(new SqLiteFileResolver(root));
    }

    @VisibleForTesting
    public InstanceLifecycleManagerSqLite(SqLiteFileResolver sqliteFileResolver) {
        this.sqLiteFileResolver = sqliteFileResolver;
    }

    @Override
    public void createNewInstance(String tenant, ProvisioningParameters provisioningParameters, BindingParameters bindingParameters) {
    }

    @Override
    public void deleteInstance(String tenant) {
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenant, boolean forceCacheUpdate) throws UnknownTenant {
        Optional<Path> path = this.findPathForTenant(tenant);
        if (path.isPresent()) {
            return this.buildWithCredentials(this.newCredentials(tenant, path.get()));
        }
        throw new UnknownTenant(tenant);
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenant) {
        if (this.findPathForTenant(tenant).isPresent()) {
            return InstanceLifecycleManager.ContainerStatus.OK;
        }
        return InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST;
    }

    @Override
    public boolean hasCredentials(String tenantId, boolean forceCacheUpdate) throws InternalError {
        return this.getContainerStatus(tenantId).equals((Object)InstanceLifecycleManager.ContainerStatus.OK);
    }

    @Override
    public Map<String, TenantMetadata> getAllTenantInfos(boolean forceCacheUpdate) {
        return this.sqLiteFileResolver.get().keySet().stream().map(s -> {
            TenantMetadata tenantInfo = new TenantMetadata((String)s);
            tenantInfo.putAdditionalProperty("database_id", s);
            return tenantInfo;
        }).filter(tenantInfo -> FilterTenants.realTenants().test(tenantInfo.getTenantId())).collect(Collectors.toMap(TenantMetadata::getTenantId, Function.identity()));
    }

    @Override
    public void checkThatTenantExists(String tenant) throws UnknownTenant {
        if (!this.findPathForTenant(tenant).isPresent()) {
            throw new UnknownTenant(tenant);
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) {
        return Collections.singletonList(dataSourceInfo);
    }

    @Override
    public List<DataSourceInfo> getLibContainers() {
        return new ArrayList<DataSourceInfo>();
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
    }

    @Override
    public boolean hasDbIdentifiers() {
        return true;
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return DbIdentifiers.DB.SQLITE;
    }

    private DbCredentials newCredentials(String tenant, Path file) {
        try {
            return new DbCredentialsSqlite(tenant, file);
        }
        catch (InternalError e) {
            throw new IllegalStateException("The DbCredentialsSqlite threw unexpected Internal Error", e);
        }
    }

    private Optional<Path> findPathForTenant(String tenant) {
        return Optional.ofNullable(this.sqLiteFileResolver.get().get(tenant));
    }

    private DataSourceInfo buildWithCredentials(DbCredentials credentials) {
        return DataSourceInfoBuilder.createBuilder().driver(credentials.getDriver()).url(credentials.getUrl()).host(credentials.getHost()).dbKey(credentials.getDatabaseId()).tenantId(credentials.getDatabaseId()).id(credentials.getDatabaseId()).databaseId(credentials.getDatabaseId()).build();
    }

    private static class DbCredentialsSqlite
    extends DbCredentials {
        public static final String DRIVER = "org.sqlite.JDBC";
        private final String tenant;
        private final Path file;

        private DbCredentialsSqlite(String tenant, Path file) throws InternalError {
            super("sa", "", "localhost", "0", DRIVER, "");
            this.tenant = tenant;
            this.file = file;
        }

        @Override
        public String getDatabaseId() {
            return this.tenant;
        }

        @Override
        public DbIdentifiers.DB getDB() {
            return DbIdentifiers.DB.SQLITE;
        }

        @Override
        public DbCredentials createCopy() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        protected String buildUrl() {
            return "jdbc:sqlite:" + this.file + "?".concat(InstanceLifecycleManagerSqLite.SQLITE_CONNECTION_OPTIONS);
        }

        @Override
        protected List<DbCredentials.HostAndPort> getHostsFromUri(URI uri) {
            return Collections.emptyList();
        }

        @Override
        protected DbCredentials.UserAndPassword getUserFromUri(URI uri) {
            return new DbCredentials.UserAndPassword();
        }
    }
}

