/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.SqlOperationsH2;
import com.sap.cloud.mt.subscription.SqlOperationsHana;
import com.sap.cloud.mt.subscription.SqlOperationsPostgreSQL;
import com.sap.cloud.mt.subscription.SqlOperationsSqLite;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class SqlOperations {
    private static final String WRONG_USER_OR_PASSWORD = "28000";
    private static final String INVALID_SCHEMA_NAME = "3F000";
    private static final String SCHEMA_NOT_FOUND = "90079";
    protected String dummySelectStatement;

    public static SqlOperations build(DbIdentifiers.DB db) throws InternalError {
        switch (db) {
            case H2: {
                return new SqlOperationsH2();
            }
            case POSTGRESQL: {
                return new SqlOperationsPostgreSQL();
            }
            case HANA: {
                return new SqlOperationsHana();
            }
            case SQLITE: {
                return new SqlOperationsSqLite();
            }
        }
        throw new InternalError("Not supported DB" + db.toString());
    }

    public void createSchema(String tenantId, Connection connection) throws SQLException {
        try (Statement createSchema = connection.createStatement();){
            createSchema.execute(this.getCreateSchemaStatement(tenantId));
        }
        catch (ParameterError parameterError) {
            throw new SQLException(parameterError);
        }
    }

    public void deleteSchema(String tenantId, Connection connection) throws SQLException {
        try (Statement deleteSchema = connection.createStatement();){
            deleteSchema.execute(this.getDeleteSchemaStatement(tenantId));
        }
        catch (ParameterError parameterError) {
            throw new SQLException(parameterError);
        }
    }

    public boolean doesSchemaExist(String tenantId, Connection connection) throws SQLException {
        return this.getAllSchemas(connection).stream().anyMatch(s -> s.equals(tenantId));
    }

    public List<String> getAllSchemas(Connection connection) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        try (Statement selectSchemas = connection.createStatement();){
            selectSchemas.execute(this.getSelectSchemaStatement());
            try (ResultSet rs = selectSchemas.getResultSet();){
                while (rs.next()) {
                    schemas.add(rs.getString(1));
                }
            }
        }
        return schemas;
    }

    public void dummySelect(Connection connection) throws SQLException {
        try (Statement dummySelect = connection.createStatement();){
            if (this.dummySelectStatement == null || this.dummySelectStatement.isEmpty()) {
                dummySelect.execute(this.getDummySelect());
            } else {
                dummySelect.execute(this.dummySelectStatement);
            }
        }
    }

    public void setDummySelectStatement(String dummySelectStatement) {
        this.dummySelectStatement = dummySelectStatement;
    }

    public boolean isAuthenticationProblem(String sqlState) {
        if (StringUtils.isBlank((CharSequence)sqlState)) {
            return false;
        }
        return sqlState.equals(WRONG_USER_OR_PASSWORD) || sqlState.equals(INVALID_SCHEMA_NAME) || sqlState.equals(SCHEMA_NOT_FOUND);
    }

    protected String getCreateSchemaStatement(String tenantId) throws ParameterError {
        Tools.checkTenantIdCharacters(tenantId);
        return "CREATE SCHEMA \"" + tenantId + "\"";
    }

    protected String getDeleteSchemaStatement(String tenantId) throws ParameterError {
        Tools.checkTenantIdCharacters(tenantId);
        return "DROP SCHEMA IF EXISTS \"" + tenantId + "\" CASCADE";
    }

    protected String getSelectSchemaStatement() {
        return "SELECT schema_name FROM information_schema.schemata";
    }

    protected String getDummySelect() {
        return "select 1 ";
    }
}

