/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DbDeployer;
import com.sap.cloud.mt.subscription.LiquibaseParameters;
import com.sap.cloud.mt.subscription.LiquibaseResourceAccessor;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import liquibase.GlobalConfiguration;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class DbDeployerLiquibase
implements DbDeployer {
    private final LiquibaseResourceAccessor resourceAccessorForTenant;
    private String fileName;
    private String contexts;

    public DbDeployerLiquibase(LiquibaseParameters parameters) {
        this.fileName = parameters.getFileName() != null ? parameters.getFileName() : "";
        this.contexts = parameters.getContexts() != null ? parameters.getContexts() : "";
        this.resourceAccessorForTenant = parameters.getResourceAccessor() != null ? parameters.getResourceAccessor() : tenantId -> new ClassLoaderResourceAccessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populate(DataSourceInfo dataSourceInfo, String tenantId) throws InternalError {
        try (Connection connection = this.getConnection(dataSourceInfo);){
            JdbcConnection liquibaseConnection = new JdbcConnection(connection);
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)liquibaseConnection);
            System.setProperty(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey(), "true");
            Class<Liquibase> clazz = Liquibase.class;
            synchronized (Liquibase.class) {
                try (Liquibase liquibase = new Liquibase(this.fileName, this.resourceAccessorForTenant.getAccessor(tenantId), database);){
                    liquibase.update(this.contexts);
                }
                // ** MonitorExit[var6_9] (shouldn't be in output)
            }
        }
        catch (SQLException | LiquibaseException sqlException) {
            throw new InternalError(sqlException);
        }
        {
            return;
        }
    }

    private Connection getConnection(DataSourceInfo dataSourceInfo) throws InternalError {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(dataSourceInfo.getUrl(), dataSourceInfo.getUser(), dataSourceInfo.getPassword());
            connection.setSchema(dataSourceInfo.getSchema());
            if (!connection.getSchema().equals(dataSourceInfo.getSchema())) {
                connection.close();
                throw new InternalError("Could not set schema to " + dataSourceInfo.getSchema());
            }
            return connection;
        }
        catch (SQLException sqlException) {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new InternalError(sqlException);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }
}

