/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.ServiceBinding;
import com.sap.cloud.mt.subscription.ServiceOperation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class ServiceInstance
extends HashMap<String, Object> {
    public static final String ID = "id";
    public static final String NAME = "name";
    private List<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
    private ServiceBinding newestBinding = null;
    private final ServiceOperation lastOperation;

    public ServiceInstance(Map<String, ?> m) {
        super(m);
        this.lastOperation = new ServiceOperation(m != null ? m : new HashMap());
    }

    public String getId() {
        return this.containsKey(ID) ? (String)this.get(ID) : "";
    }

    public boolean isReady() {
        return this.containsKey("ready") && (Boolean)this.get("ready") != false;
    }

    public String getName() {
        return this.containsKey(NAME) ? (String)this.get(NAME) : "";
    }

    public String getServicePlanId() {
        return (String)this.get("service_plan_id");
    }

    public List<String> getTenants() {
        Map labels = (Map)this.get("labels");
        if (labels == null) {
            return new ArrayList<String>();
        }
        List tenants = (List)labels.get("tenant_id");
        return tenants != null ? tenants.stream().filter(t -> !StringUtils.isBlank((CharSequence)t)).toList() : new ArrayList<String>();
    }

    public void insertTenant(String tenantId) {
        ArrayList<String> tenants;
        HashMap<String, ArrayList<String>> labels = (HashMap<String, ArrayList<String>>)this.get("labels");
        if (labels == null) {
            labels = new HashMap<String, ArrayList<String>>();
            this.put("labels", labels);
        }
        if ((tenants = (ArrayList<String>)labels.get("tenant_id")) == null) {
            tenants = new ArrayList<String>();
            labels.put("tenant_id", tenants);
        }
        tenants.add(tenantId);
    }

    public boolean hasTenant() {
        return !this.getTenants().isEmpty();
    }

    public Instant getCreatedAt() {
        return Instant.parse((String)this.get("created_at"));
    }

    public Instant getUpdatedAt() {
        return Instant.parse((String)this.get("updated_at"));
    }

    public String getUsable() {
        return (String)this.get("usable");
    }

    public ServiceOperation getLastOperation() {
        return this.lastOperation;
    }

    public List<ServiceBinding> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<ServiceBinding> bindings) {
        this.bindings = bindings != null ? bindings : new ArrayList();
        AtomicReference<Object> newestBindingRef = new AtomicReference<Object>(null);
        this.bindings.stream().filter(b -> b.getServiceInstanceId().equals(this.getId())).filter(ServiceBinding::isUsable).forEach((? super T b) -> {
            if (newestBindingRef.get() == null || b.getCreatedAt().isAfter(((ServiceBinding)newestBindingRef.get()).getCreatedAt())) {
                newestBindingRef.set(b);
            }
        });
        this.newestBinding = newestBindingRef.get() == null ? null : (ServiceBinding)newestBindingRef.get();
    }

    public Optional<ServiceBinding> getBinding() {
        return this.newestBinding != null ? Optional.of(this.newestBinding) : Optional.empty();
    }

    public boolean isUsable() {
        ServiceOperation.Status status = this.lastOperation.getStatus();
        return this.isReady() && (this.lastOperation.getType() != ServiceOperation.Type.CREATE || status != ServiceOperation.Status.FAILED && status != ServiceOperation.Status.IN_PROGRESS);
    }

    private boolean bindingTenantIsContainedInInstanceTenant(List<String> instanceTenants, List<String> bindingTenants) {
        return instanceTenants.stream().anyMatch(bindingTenants::contains);
    }
}

