/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.BindingParameters;
import com.sap.cloud.mt.subscription.PollingParameters;
import com.sap.cloud.mt.subscription.ProvisioningParameters;
import com.sap.cloud.mt.subscription.ServiceBinding;
import com.sap.cloud.mt.subscription.ServiceInstance;
import com.sap.cloud.mt.subscription.ServiceOperation;
import com.sap.cloud.mt.subscription.ServiceSpecification;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.tools.api.QueryParameter;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    public static final String SM_URL = "sm_url";
    public static final String LINK = "link";
    public static final String TOKEN = "token";
    public static final Map<String, String> CALLED_FROM;
    private static final Logger logger;
    private static final String SERVICE_INSTANCES_ENDPOINT = "/v1/service_instances";
    private static final String SERVICE_BINDINGS_ENDPOINT = "/v1/service_bindings";
    private static final String SERVICE_PLANS_ENDPOINT = "/v1/service_plans";
    private static final String SERVICE_OFFERINGS_ENDPOINT = "/v1/service_offerings";
    private static final String FIELD_QUERY = "fieldQuery";
    private static final String LABEL_QUERY = "labelQuery";
    private static final String ID = "id";
    private static final String ITEMS = "items";
    public static final String UNEXPECTED_RETURN_CODE = "unexpected return code %d";
    public static final String ASYNC = "async";
    public static final String SUCCEEDED = "succeeded";
    public static final String IN_PROGRESS = "in progress";
    public static final String FAILED = "failed";
    public static final String LOCATION = "location";
    public static final String INSTANCE_ID_IS_EMPTY = "Instance id is empty";
    public static final String TENANT_ID = "tenant_id";
    public static final String MANAGING_CLIENT_LIB = "managing_client_lib";
    public static final String SERVICE_PLAN_ID = "service_plan_id";
    public static final String INSTANCE_MANAGER_CLIENT_LIB = "instance-manager-client-lib";
    public static final String TENANT_ID_IS_EMPTY = "Tenant id is empty";
    public static final String ATTACH_LAST_OPERATIONS = "attach_last_operations";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConcurrentHashMap<String, String> planIdMap = new ConcurrentHashMap();
    private final Set<Integer> retryCodes = new HashSet<Integer>();
    private final ServiceEndpoint instancesEndpoint;
    private final ServiceEndpoint bindingsEndpoint;
    private final ServiceEndpoint oneInstanceEndpoint;
    private final ServiceEndpoint oneBindingEndpoint;
    private final ServiceEndpoint instancesAsyncEndpoint;
    private final ServiceEndpoint bindingsAsyncEndpoint;
    private final ServiceEndpoint plansEndpoint;
    private final ServiceEndpoint offeringsEndpoint;
    private final ServiceEndpoint locationEndpoint;
    private final String serviceOfferingName;
    private final String planName;
    private final ServiceSpecification serviceSpecification;
    private final String serviceInstanceName;

    public ServiceManager(com.sap.cloud.environment.servicebinding.api.ServiceBinding serviceBinding, ServiceSpecification serviceSpecification, String serviceOfferingName, String planName) throws InternalError {
        this.serviceOfferingName = serviceOfferingName;
        this.planName = planName;
        this.serviceSpecification = serviceSpecification;
        this.serviceInstanceName = (String)serviceBinding.getName().orElseThrow(() -> new InternalError("Service instance name is missing"));
        this.retryCodes.add(502);
        this.retryCodes.add(504);
        this.retryCodes.add(500);
        this.retryCodes.add(503);
        HttpDestination destination = ServiceManager.getDestination(serviceBinding);
        try {
            this.offeringsEndpoint = this.createEndpoint(destination, SERVICE_OFFERINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200)));
            this.plansEndpoint = this.createEndpoint(destination, SERVICE_PLANS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200)));
            this.instancesEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 201)));
            this.oneInstanceEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 404)));
            this.bindingsEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 201)));
            this.oneBindingEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 404)));
            this.instancesAsyncEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(202)));
            this.bindingsAsyncEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(202)));
            this.locationEndpoint = this.createEndpoint(destination, "", new HashSet<Integer>(Arrays.asList(200)));
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public List<ServiceInstance> readInstances() throws InternalError {
        return this.readInstances(null, null);
    }

    public Optional<ServiceInstance> readInstanceForTenant(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        return this.extractServiceInstance(this.readInstancesMaps(tenantId, null), "Multiple instances found for tenant id %s".formatted(tenantId));
    }

    public Optional<ServiceInstance> readInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        return this.extractServiceInstance(this.readInstancesMaps(null, instanceId), "Multiple instances found for instance id %s".formatted(instanceId));
    }

    public List<ServiceBinding> readBindings() throws InternalError {
        return this.readBindings(null, null, null);
    }

    public List<ServiceBinding> readBindingsForTenant(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        return this.readBindings(tenantId, null, null);
    }

    public List<ServiceBinding> readBindingsForInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        return this.readBindings(null, instanceId, null);
    }

    public Optional<ServiceBinding> readBinding(String bindingId) throws InternalError {
        return this.extractServiceBinding(this.readBindingsMaps(null, null, bindingId), "Multiple bindings found for binding id %s".formatted(bindingId));
    }

    public Optional<ServiceInstance> createInstance(String tenantId, ProvisioningParameters parameters) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        HashMap<String, List<String>> labels = new HashMap<String, List<String>>();
        labels.put(TENANT_ID, Arrays.asList(tenantId));
        CreateInstancePayload payload = new CreateInstancePayload(this.getPlanId(), this.calculateServiceInstanceName(tenantId), parameters, labels);
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall createInstances = this.instancesAsyncEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to create service instances for tenant id {} and payload {}", (Object)tenantId, Tools.lazyJson(() -> payload));
            ServiceResponse response = createInstances.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equals(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous create instance operation");
            }
            String locationUrl = locationHeader.get().getValue();
            String instanceId = this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
            return this.readInstance(instanceId);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String deleteInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall deleteInstance = this.instancesAsyncEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(instanceId).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to delete service instance {} ", (Object)instanceId);
            ServiceResponse response = deleteInstance.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equals(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous delete instance operation");
            }
            String locationUrl = locationHeader.get().getValue();
            return this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public Optional<ServiceBinding> createBinding(String tenantId, String serviceInstanceId, BindingParameters parameters) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)serviceInstanceId)) {
            throw new InternalError("Service instance id is empty");
        }
        HashMap<String, List<String>> labels = new HashMap<String, List<String>>();
        labels.put(TENANT_ID, Arrays.asList(tenantId));
        labels.put(MANAGING_CLIENT_LIB, Arrays.asList(INSTANCE_MANAGER_CLIENT_LIB));
        labels.put(SERVICE_PLAN_ID, Arrays.asList(this.getPlanId()));
        CreateBindingPayload payload = new CreateBindingPayload(serviceInstanceId, UUID.randomUUID().toString(), parameters, labels);
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall createBindings = this.bindingsAsyncEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to create new binding with payload {}", Tools.lazyJson(() -> payload));
            ServiceResponse response = createBindings.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equals(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous create binding operation");
            }
            String locationUrl = locationHeader.get().getValue();
            String bindingId = this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
            return this.readBinding(bindingId);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String deleteBinding(String bindingId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)bindingId)) {
            throw new InternalError("Binding id is empty");
        }
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall deleteBindings = this.bindingsAsyncEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(bindingId).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to delete binding {}", (Object)bindingId);
            ServiceResponse response = deleteBindings.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equals(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous delete binding operation");
            }
            String locationUrl = locationHeader.get().getValue();
            return this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    private List<ServiceInstance> readInstances(String tenantId, String instanceId) throws InternalError {
        ArrayList<ServiceInstance> result = new ArrayList<ServiceInstance>();
        this.readInstancesMaps(tenantId, instanceId).stream().forEach(map -> result.add(new ServiceInstance((Map<String, ?>)map)));
        return result;
    }

    private List<Map<String, Object>> readInstancesMaps(String tenantId, String instanceId) throws InternalError {
        return this.readInstancesMapsInt(tenantId, instanceId, Optional.empty());
    }

    private List<Map<String, Object>> readInstancesMapsInt(String tenantId, String instanceId, Optional<String> token) throws InternalError {
        ArrayList<QueryParameter> query = new ArrayList<QueryParameter>();
        token.ifPresent(t -> query.add(new QueryParameter(TOKEN, t)));
        query.add(new QueryParameter(FIELD_QUERY, "service_plan_id eq '%s'".formatted(this.getPlanId())));
        query.add(new QueryParameter(ATTACH_LAST_OPERATIONS, "true"));
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            query.add(new QueryParameter(LABEL_QUERY, "tenant_id eq '%s'".formatted(tenantId)));
        }
        try {
            ServiceCall getInstances;
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                getInstances = this.oneInstanceEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(instanceId).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
                logger.debug("Call service manager to determine service instance with instance id {}", (Object)instanceId);
            } else {
                getInstances = this.instancesEndpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    logger.debug("Call service manager to determine service instances with tenant id {}", (Object)tenantId);
                } else {
                    logger.debug("Call service manager to determine all service instances");
                }
            }
            ServiceResponse response = getInstances.execute(Map.class);
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                if (response.getHttpStatusCode() == 404 || response.getPayload().isEmpty()) {
                    return new ArrayList<Map<String, Object>>();
                }
                return Arrays.asList(response.getPayload().orElse(new HashMap()));
            }
            List<Map<String, Object>> instances = this.getItems(response.getPayload().orElse(new HashMap()));
            Optional<String> tokenOpt = response.getPayload().map(p -> (String)p.get(TOKEN));
            if (tokenOpt.isPresent()) {
                instances.addAll(this.readInstancesMapsInt(tenantId, null, tokenOpt));
            }
            return instances;
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private List<ServiceBinding> readBindings(String tenantId, String instanceId, String bindingId) throws InternalError {
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        this.readBindingsMaps(tenantId, instanceId, bindingId).stream().forEach(map -> bindings.add(new ServiceBinding((Map<String, ?>)map)));
        return bindings;
    }

    private List<Map<String, Object>> readBindingsMaps(String tenantId, String instanceId, String bindingId) throws InternalError {
        return this.readBindingsMapsInt(tenantId, instanceId, bindingId, Optional.empty());
    }

    private List<Map<String, Object>> readBindingsMapsInt(String tenantId, String instanceId, String bindingId, Optional<String> token) throws InternalError {
        try {
            ArrayList<QueryParameter> query = new ArrayList<QueryParameter>();
            token.ifPresent(t -> query.add(new QueryParameter(TOKEN, t)));
            query.add(new QueryParameter(ATTACH_LAST_OPERATIONS, "true"));
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                query.add(new QueryParameter(FIELD_QUERY, "service_instance_id eq '%s'".formatted(instanceId)));
            }
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                query.add(new QueryParameter(LABEL_QUERY, "service_plan_id eq '%s' and managing_client_lib eq 'instance-manager-client-lib' and tenant_id eq '%s'".formatted(this.getPlanId(), tenantId)));
            } else {
                query.add(new QueryParameter(LABEL_QUERY, "service_plan_id eq '%s' and managing_client_lib eq 'instance-manager-client-lib'".formatted(this.getPlanId())));
            }
            ServiceCall getBindings = StringUtils.isNotBlank((CharSequence)bindingId) ? this.oneBindingEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(bindingId).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end() : this.bindingsEndpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine service bindings for tenant id {} instance id {} binding id {}", new Object[]{tenantId, instanceId, bindingId});
            ServiceResponse response = getBindings.execute(Map.class);
            if (StringUtils.isNotBlank((CharSequence)bindingId)) {
                if (response.getHttpStatusCode() == 404 || response.getPayload().isEmpty()) {
                    return new ArrayList<Map<String, Object>>();
                }
                return Arrays.asList(response.getPayload().orElse(new HashMap()));
            }
            List<Map<String, Object>> bindings = this.getItems(response.getPayload().orElse(new HashMap()));
            Optional<String> tokenOpt = response.getPayload().map(p -> (String)p.get(TOKEN));
            if (tokenOpt.isPresent()) {
                bindings.addAll(this.readBindingsMapsInt(tenantId, instanceId, null, tokenOpt));
            }
            return bindings;
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private String readOfferingId(String offeringName) throws InternalError {
        String offeringId = "";
        try {
            ServiceCall getOfferings = this.offeringsEndpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(Arrays.asList(new QueryParameter(FIELD_QUERY, "catalog_name eq '%s'".formatted(offeringName)))).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine service offerings for {}", (Object)offeringName);
            ServiceResponse response = getOfferings.execute(Map.class);
            offeringId = this.getIdFromItems((ServiceResponse<Map>)response, "No service offering found for %s ".formatted(offeringName), "Multiple offerings found for %s".formatted(offeringName), "No service offering id is contained in payload");
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
        if (StringUtils.isBlank((CharSequence)offeringId)) {
            throw new InternalError("Could not determine offering id for %s".formatted(offeringName));
        }
        return offeringId;
    }

    private String readPlanId(String serviceOfferingId) throws InternalError {
        String planId = "";
        try {
            ServiceCall getPlans = this.plansEndpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(Arrays.asList(new QueryParameter(FIELD_QUERY, "catalog_name eq '%s' and service_offering_id eq '%s'".formatted(this.planName, serviceOfferingId)))).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine plan id for {}", (Object)this.planName);
            ServiceResponse response = getPlans.execute(Map.class);
            planId = this.getIdFromItems((ServiceResponse<Map>)response, "No service plan found for %s".formatted(this.planName), "Multiple plans found for %s".formatted(this.planName), "No service plan id is contained in payload");
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
        if (StringUtils.isBlank((CharSequence)planId)) {
            throw new InternalError("Could not determine plan id for %s".formatted(this.planName));
        }
        return planId;
    }

    private String getIdFromItems(ServiceResponse<Map> response, String noItemsText, String toManyItemsText, String noIdText) throws InternalError {
        List<Map<String, Object>> items = this.getItems(response.getPayload().orElse(new HashMap()));
        if (items.isEmpty()) {
            throw new InternalError(noItemsText);
        }
        if (items.size() > 1) {
            throw new InternalError(toManyItemsText);
        }
        Map<String, Object> item = items.get(0);
        if (item.get(ID) == null) {
            throw new InternalError(noIdText);
        }
        return (String)item.get(ID);
    }

    private List<Map<String, Object>> getItems(Map<String, Object> payload) {
        if (payload.containsKey(ITEMS)) {
            return (List)payload.get(ITEMS);
        }
        return new ArrayList<Map<String, Object>>();
    }

    private String getPlanId() throws InternalError {
        try {
            return this.planIdMap.computeIfAbsent(this.serviceOfferingName, key -> {
                try {
                    String offeringId = this.readOfferingId(this.serviceOfferingName);
                    return this.readPlanId(offeringId);
                }
                catch (InternalError error) {
                    throw new DeterminationError("Could not determine offering id", error);
                }
            });
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private String waitForCompletionAndGetId(String path, PollingParameters pollingParameter) throws InternalError {
        Instant start = Instant.now();
        while (true) {
            logger.debug("Wait for completion of operation {}", (Object)path);
            ServiceOperation result = this.getOperationResult(path);
            if (result.isReady() && !IN_PROGRESS.equals(result.getState())) {
                String state = result.getState();
                if (SUCCEEDED.equals(state)) {
                    if (StringUtils.isBlank((CharSequence)result.getResourceId())) {
                        throw new InternalError("No id returned");
                    }
                    return result.getResourceId();
                }
                String errorJson = "";
                if (result.getErrors() != null) {
                    try {
                        errorJson = this.mapper.writeValueAsString(result.getErrors());
                    }
                    catch (JsonProcessingException e) {
                        errorJson = "";
                    }
                }
                throw new InternalError("Operation failed with state %s and error %s".formatted(state, errorJson));
            }
            if (Duration.between(start, Instant.now()).compareTo(pollingParameter.getRequestTimeout()) >= 0) {
                throw new InternalError("Maximum waiting time on operation %s exceeded".formatted(path));
            }
            Tools.waitSomeTime(pollingParameter.getInterval());
        }
    }

    private ServiceOperation getOperationResult(String path) throws InternalError {
        try {
            ServiceCall getOperationResult = this.locationEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(path).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine operation status for {}", (Object)path);
            ServiceResponse response = getOperationResult.execute(Map.class);
            return new ServiceOperation(response.getPayload().orElse(new HashMap()));
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private ServiceEndpoint createEndpoint(HttpDestination destination, String path, Set<Integer> expectedResponseCodes) throws InternalException {
        return ServiceEndpoint.create().destination(destination).path(path).returnCodeChecker(c -> {
            if (!expectedResponseCodes.contains(c)) {
                return new InternalError(UNEXPECTED_RETURN_CODE.formatted(c));
            }
            return null;
        }).retry().forReturnCodes(this.retryCodes).config(this.serviceSpecification.getResilienceConfig()).end();
    }

    private InternalError serviceErrorHandling(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof InternalError) {
            InternalError internalError = (InternalError)throwable;
            return internalError;
        }
        return new InternalError(e);
    }

    private Optional<ServiceInstance> extractServiceInstance(List<Map<String, Object>> instances, String tooManyErrorText) throws InternalError {
        Map<String, Object> instanceData = this.extractSingleItem(instances, tooManyErrorText);
        return !instanceData.isEmpty() ? Optional.of(new ServiceInstance(instanceData)) : Optional.empty();
    }

    private Optional<ServiceBinding> extractServiceBinding(List<Map<String, Object>> bindings, String tooManyErrorText) throws InternalError {
        Map<String, Object> bindingData = this.extractSingleItem(bindings, tooManyErrorText);
        return !bindingData.isEmpty() ? Optional.of(new ServiceBinding(bindingData)) : Optional.empty();
    }

    private Map<String, Object> extractSingleItem(List<Map<String, Object>> instances, String tooManyErrorText) throws InternalError {
        if (instances.isEmpty()) {
            return new HashMap<String, Object>();
        }
        if (instances.size() > 1) {
            throw new InternalError(tooManyErrorText);
        }
        return instances.get(0);
    }

    private String calculateServiceInstanceName(String tenantId) throws InternalError {
        byte[] hash = DigestUtils.sha256((String)(this.getPlanId() + "_" + tenantId));
        return Base64.encodeBase64String((byte[])hash);
    }

    private static HttpDestination getDestination(com.sap.cloud.environment.servicebinding.api.ServiceBinding binding) throws InternalError {
        if (StringUtils.isBlank((CharSequence)((String)binding.getCredentials().get(SM_URL)))) {
            throw new InternalError("Service manager url is missing");
        }
        if (binding.getName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getName().get()))) {
            throw new InternalError("Service binding name is missing");
        }
        if (binding.getServiceName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getServiceName().get()))) {
            throw new InternalError("Service name is missing");
        }
        return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((com.sap.cloud.environment.servicebinding.api.ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
    }

    static {
        ServiceManagerPropertySupplier.initialize();
        CALLED_FROM = Map.of("Client-Name", "cap-java-client", "Client-Version", "2.0.0");
        logger = LoggerFactory.getLogger(ServiceManager.class);
    }

    private record CreateInstancePayload(String service_plan_id, String name, Map<String, Object> parameters, Map<String, List<String>> labels) {
    }

    private record CreateBindingPayload(String service_instance_id, String name, Map<String, Object> parameters, Map<String, List<String>> labels) {
    }

    private static class DeterminationError
    extends RuntimeException {
        public DeterminationError() {
        }

        public DeterminationError(String message) {
            super(message);
        }

        public DeterminationError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ServiceManagerPropertySupplier
    extends DefaultOAuth2PropertySupplier {
        public static final String SERVICE_MANAGER = "service-manager";
        private static boolean initialized = false;

        public static synchronized void initialize() {
            if (!initialized) {
                OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(ServiceManagerPropertySupplier::matches, ServiceManagerPropertySupplier::new);
                initialized = true;
            }
        }

        public ServiceManagerPropertySupplier(ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        public URI getServiceUri() {
            return (URI)this.getOAuthCredentialOrThrow(URI.class, new String[]{ServiceManager.SM_URL});
        }

        public URI getTokenUri() {
            return (URI)this.getOAuthCredential(URI.class, new String[]{"certurl"}).getOrElse((Object)((URI)this.getOAuthCredentialOrThrow(URI.class, new String[]{"url"})));
        }

        public ClientIdentity getClientIdentity() {
            return this.getOAuthCredential(String.class, new String[]{"certurl"}).isDefined() ? this.getCertificateIdentity() : this.getSecretIdentity();
        }

        ClientIdentity getCertificateIdentity() {
            String clientid = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientid"});
            String cert = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"certificate"});
            String key = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"key"});
            return new ClientCertificate(cert, key, clientid);
        }

        ClientIdentity getSecretIdentity() {
            String clientid = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientid"});
            String secret = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientsecret"});
            return new ClientCredentials(clientid, secret);
        }

        private static boolean matches(ServiceBindingDestinationOptions options) {
            return ServiceManagerPropertySupplier.matches(options.getServiceBinding(), SERVICE_MANAGER, SERVICE_MANAGER);
        }

        public static boolean matches(com.sap.cloud.environment.servicebinding.api.ServiceBinding binding, String tagFilter, String serviceNameFilter) {
            boolean tagsMatched = false;
            if (tagFilter != null && binding.getTags() != null && !binding.getTags().isEmpty()) {
                tagsMatched = binding.getTags().contains(tagFilter);
            }
            return tagsMatched || serviceNameFilter != null && serviceNameFilter.equals(binding.getServiceName().orElse(null));
        }
    }
}

