/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbCredentialsBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.DbIdentifiersSqLite;
import com.sap.cloud.mt.subscription.DbIdentifiersSql;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerImpl;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerSqLite;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerSqlDb;
import com.sap.cloud.mt.subscription.ServiceManager;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceLifecycleManagerBuilder {
    private ServiceManager serviceManager;
    private DbIdentifiers dbIdentifiers;
    private List<DbCredentials> dbCredentialsList = new ArrayList<DbCredentials>();
    private DbIdentifiers.DB db = DbIdentifiers.DB.NONE;
    private Duration smCacheRefreshInterval;
    private ResilienceConfig serviceManagerCacheResilienceConfig = ResilienceConfig.NONE;
    private static ConcurrentHashMap<String, InstanceLifecycleManagerImpl> smIdToILM = new ConcurrentHashMap();

    public InstanceLifecycleManager build() throws InternalError {
        if (this.serviceManager != null) {
            if (this.dbIdentifiers != null && !(this.dbIdentifiers instanceof DbIdentifiersHana)) {
                throw new InternalError("Hana database specified with database identifiers of non-HANA DB");
            }
            if (this.dbIdentifiers == null) {
                this.dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());
            }
            return smIdToILM.computeIfAbsent(this.serviceManager.getServiceInstanceName(), id -> new InstanceLifecycleManagerImpl(this.serviceManager, (DbIdentifiersHana)this.dbIdentifiers, this.smCacheRefreshInterval, this.serviceManagerCacheResilienceConfig));
        }
        if (this.dbIdentifiers != null) {
            if (this.dbIdentifiers instanceof DbIdentifiersSql) {
                return new InstanceLifecycleManagerSqlDb((DbIdentifiersSql)this.dbIdentifiers);
            }
            if (this.dbIdentifiers instanceof DbIdentifiersSqLite) {
                return new InstanceLifecycleManagerSqLite(((DbIdentifiersSqLite)this.dbIdentifiers).getRoot());
            }
            throw new InternalError("No database credentials provided");
        }
        if (!this.dbCredentialsList.isEmpty()) {
            if (this.db == DbIdentifiers.DB.NONE) {
                throw new InternalError("No database type set");
            }
            return new InstanceLifecycleManagerSqlDb(new DbIdentifiersSql(this.dbCredentialsList));
        }
        throw new InternalError("No instance manager, service manager or databases specified");
    }

    public static InstanceLifecycleManagerBuilder create() {
        return new InstanceLifecycleManagerBuilder();
    }

    private InstanceLifecycleManagerBuilder() {
    }

    public InstanceLifecycleManagerBuilder serviceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        return this;
    }

    public InstanceLifecycleManagerBuilder dbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIdentifiers = dbIdentifiers;
        return this;
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(Map<String, Object> credentials) throws InternalError {
        return this.addDbCredentials(DbIdentifiers.DB.NONE, credentials);
    }

    public InstanceLifecycleManagerBuilder smCacheRefreshInterval(Duration smCacheRefreshInterval) {
        this.smCacheRefreshInterval = smCacheRefreshInterval;
        return this;
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(DbIdentifiers.DB db, Map<String, Object> credentials) throws InternalError {
        DbCredentialsBuilder dbCredentialsBuilder = DbCredentialsBuilder.create().db(db).credentials(credentials);
        DbCredentials dbCredentials = dbCredentialsBuilder.build();
        this.dbCredentialsList.add(dbCredentials);
        if (this.db != DbIdentifiers.DB.NONE && this.db != dbCredentials.getDB()) {
            throw new InternalError("It is not possible to combine different types of databases for multi tenancy");
        }
        if (this.db == DbIdentifiers.DB.NONE) {
            this.db = dbCredentials.getDB();
        }
        return this;
    }

    public InstanceLifecycleManagerBuilder smCacheResilienceConfig(ResilienceConfig resilienceConfig) {
        if (resilienceConfig != null) {
            this.serviceManagerCacheResilienceConfig = resilienceConfig;
        }
        return this;
    }
}

