/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.BindingParameters;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersHana;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.ProvisioningParameters;
import com.sap.cloud.mt.subscription.ServiceBinding;
import com.sap.cloud.mt.subscription.ServiceInstance;
import com.sap.cloud.mt.subscription.ServiceManager;
import com.sap.cloud.mt.subscription.ServiceManagerCache;
import com.sap.cloud.mt.subscription.ServiceOperation;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.UuidChecker;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerImpl
implements InstanceLifecycleManager {
    private static final Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerImpl.class);
    private static final String HOST = "host";
    public static final String CREATION_SUCCEEDED = "CREATION_SUCCEEDED";
    private final ServiceManagerCache serviceManagerCache;
    private final DbIdentifiersProxy dbIdentifiersProxy = new DbIdentifiersProxy();

    InstanceLifecycleManagerImpl(ServiceManager serviceManager, DbIdentifiersHana dbIdentifiers, Duration smCacheRefreshInterval, ResilienceConfig serviceManagerCacheResilienceConfig) {
        if (dbIdentifiers != null) {
            dbIdentifiers.getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
        }
        this.serviceManagerCache = new ServiceManagerCache(serviceManager, smCacheRefreshInterval, serviceManagerCacheResilienceConfig != null ? serviceManagerCacheResilienceConfig : ResilienceConfig.NONE);
    }

    @Override
    public void createNewInstance(String tenantId, ProvisioningParameters instanceParameters, BindingParameters bindingParameters) throws InternalError {
        String databaseId;
        if (!MapUtils.isEmpty((Map)instanceParameters) && (databaseId = (String)instanceParameters.get("database_id")) != null) {
            logger.debug("Using database id {}", (Object)databaseId);
        }
        this.serviceManagerCache.createInstance(tenantId, instanceParameters, bindingParameters);
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        try {
            this.checkThatTenantExists(tenantId);
        }
        catch (UnknownTenant unknownTenant) {
            logger.warn("No HDI container for tenant {} found", (Object)tenantId);
            return;
        }
        this.serviceManagerCache.deleteInstance(tenantId);
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        return this.getDataSourceInfoInternal(tenantId, forceCacheUpdate);
    }

    protected DataSourceInfo getDataSourceInfoInternal(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        ServiceInstance instance = null;
        try {
            instance = this.serviceManagerCache.getInstance(tenantId, forceCacheUpdate).orElseThrow(() -> new UnknownTenant("Tenant [" + tenantId + "] is not known"));
        }
        catch (InternalError e) {
            throw new UnknownTenant(e, "Tenant [" + tenantId + "] is not known");
        }
        ServiceBinding binding = instance.getBinding().orElseThrow(() -> new InternalError("Database container service instance for tenant %s doesn't have a ready binding".formatted(tenantId)));
        Map<String, Object> credentials = binding.getCredentials();
        return DataSourceInfoBuilder.createBuilder().host((String)credentials.get(HOST)).port((String)credentials.get("port")).driver((String)credentials.get("driver")).url((String)credentials.get("url")).schema((String)credentials.get("schema")).hdiUser((String)credentials.get("hdi_user")).hdiPassword((String)credentials.get("hdi_password")).user((String)credentials.get("user")).password((String)credentials.get("password")).certificate((String)credentials.get("certificate")).tenantId(tenantId).id(instance.getId()).statusAsText(CREATION_SUCCEEDED).dbKey(this.createDbKey((String)credentials.get(HOST), (String)credentials.get("port"))).databaseId(this.getDatabaseId(credentials)).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        return this.serviceManagerCache.getInstance(tenantId, true).stream().map(instance -> {
            ServiceOperation.Status status = instance.getLastOperation().getStatus();
            ServiceOperation.Type type = instance.getLastOperation().getType();
            if (type == ServiceOperation.Type.CREATE && !instance.isReady() && status == ServiceOperation.Status.FAILED) {
                return InstanceLifecycleManager.ContainerStatus.CREATION_ERROR;
            }
            if (type == ServiceOperation.Type.CREATE && status == ServiceOperation.Status.IN_PROGRESS) {
                return InstanceLifecycleManager.ContainerStatus.CREATION_IN_PROGRESS;
            }
            return InstanceLifecycleManager.ContainerStatus.OK;
        }).findFirst().orElse(InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST);
    }

    @Override
    public Map<String, TenantMetadata> getAllTenantInfos(boolean forceCacheUpdate) throws InternalError {
        List<ServiceInstance> instances = null;
        instances = this.serviceManagerCache.getInstances(forceCacheUpdate);
        if (instances == null) {
            return new HashMap<String, TenantMetadata>();
        }
        return instances.stream().filter(i -> i.isUsable()).flatMap(instance -> {
            ArrayList<TenantMetadata> tenantInfoList = new ArrayList<TenantMetadata>();
            Optional<ServiceBinding> binding = instance.getBinding();
            String dbId = null;
            if (binding.isPresent()) {
                dbId = this.getDatabaseId(instance.getBinding().get().getCredentials());
            }
            for (String tenantId : instance.getTenants()) {
                TenantMetadata tenantInfo = new TenantMetadata(tenantId);
                if (dbId != null) {
                    tenantInfo.putAdditionalProperty("database_id", dbId);
                }
                tenantInfoList.add(tenantInfo);
            }
            return tenantInfoList.stream();
        }).filter(tenantInfo -> FilterTenants.realTenants().test(tenantInfo.getTenantId())).collect(Collectors.toMap(TenantMetadata::getTenantId, Function.identity()));
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant, InternalError {
        if (this.serviceManagerCache.getInstance(tenantId, false).isEmpty()) {
            throw new UnknownTenant("Tenant " + tenantId + " is not known");
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) throws InternalError {
        String databaseId = null;
        if (dataSourceInfo != null) {
            databaseId = dataSourceInfo.getDatabaseId();
        }
        Set<String> missingLibContainersDbIds = new HashSet<String>();
        if (databaseId != null) {
            if (this.isLibContainerMissing(databaseId)) {
                missingLibContainersDbIds.add(databaseId);
            }
        } else {
            missingLibContainersDbIds = this.getMissingLibContainers(this.dbIdentifiersProxy.getDbIds());
        }
        missingLibContainersDbIds.stream().forEach(id -> {
            try {
                logger.debug("Create new mt-lib container for database {}", id);
                this.createNewInstance(this.getMtLibContainerName((String)id), this.createProvisioningParameters((String)id), new BindingParameters());
            }
            catch (InternalError internalError) {
                logger.debug("Could not create new mt-lib container for database {} because of {} ", id, (Object)internalError.getMessage());
            }
        });
        return this.getLibContainers();
    }

    @Override
    public List<DataSourceInfo> getLibContainers() {
        ArrayList<DataSourceInfo> dsInfo = new ArrayList<DataSourceInfo>();
        this.dbIdentifiersProxy.getDbIds().stream().forEach(id -> {
            try {
                dsInfo.add(this.getDataSourceInfo(this.getMtLibContainerName((String)id), false));
            }
            catch (InternalError | UnknownTenant exception) {
                // empty catch block
            }
        });
        return dsInfo;
    }

    public void clearCache() {
        this.serviceManagerCache.clearCache();
    }

    private Set<String> getMissingLibContainers(Set<String> dbIds) {
        return dbIds.stream().filter(this::isLibContainerMissing).collect(Collectors.toSet());
    }

    private boolean isLibContainerMissing(String dbId) {
        try {
            return this.serviceManagerCache.getInstance(this.getMtLibContainerName(dbId), false).isEmpty();
        }
        catch (InternalError e) {
            return true;
        }
    }

    private DbIdentifiers getDbIdentifiers() {
        return this.dbIdentifiersProxy.createCopy();
    }

    @Override
    public boolean hasDbIdentifiers() {
        return this.dbIdentifiersProxy.areSet();
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
        ((DbIdentifiersHana)dbIdentifiers).getDbIds().stream().forEach(this.dbIdentifiersProxy::add);
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return this.dbIdentifiersProxy.getDbType();
    }

    private String createDbKey(String host, String port) {
        return host + ":" + port;
    }

    private String getDatabaseId(Map<String, Object> credentials) {
        String databaseId = (String)credentials.get("database_id");
        if (StringUtils.isNotEmpty((CharSequence)databaseId)) {
            return databaseId;
        }
        databaseId = StringUtils.substringBefore((String)((String)credentials.get(HOST)), (String)".");
        return UuidChecker.isUUId((String)databaseId) ? databaseId : null;
    }

    @Override
    public boolean knowsDbCredentials() {
        try {
            List<ServiceInstance> instances = this.serviceManagerCache.getInstances(false);
            return instances != null && !instances.isEmpty();
        }
        catch (InternalError e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBlockRefresh(BooleanSupplier blockRefresh) {
        ServiceManagerCache.setBlockRefresh(blockRefresh);
    }

    private class DbIdentifiersProxy {
        private final DbIdentifiersHana dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());

        private DbIdentifiersProxy() {
        }

        public void add(String dbId) {
            this.dbIdentifiers.add(dbId);
        }

        public DbIdentifiers.DB getDbType() {
            return this.dbIdentifiers.getDB();
        }

        public boolean areSet() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.areSet();
        }

        public DbIdentifiers createCopy() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.createCopy();
        }

        public Set<String> getDbIds() {
            this.updateDbIdentifiers();
            return this.dbIdentifiers.getDbIds();
        }

        private synchronized void updateDbIdentifiers() {
            try {
                List<ServiceInstance> instances = InstanceLifecycleManagerImpl.this.serviceManagerCache.getInstances(false);
                if (instances != null) {
                    instances.stream().filter(i -> i.getBinding().isPresent()).map(i -> i.getBinding().get().getCredentials()).filter(Objects::nonNull).map(InstanceLifecycleManagerImpl.this::getDatabaseId).filter(Objects::nonNull).map(Object::toString).forEach(this::add);
                }
            }
            catch (InternalError e) {
                logger.error("Could not access SM", (Throwable)e);
            }
        }
    }
}

