/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.subscription;

/**
 * Created by d025461 on 09.05.17.
 */
public class DataSourceInfo {
    private String schema;
    private String driver;
    private String port;
    private String host;
    private String user;
    private String password;
    private String hdiUser;
    private String hdiPassword;
    private String url;
    private String certificate;
    private String tenantId;
    private String id;
    private String statusAsText;
    private String dbKey;
    private String databaseId;

    public DataSourceInfo() {
    }
    public DataSourceInfo(DataSourceInfo di) {
        this.schema=di.schema;
        this.driver=di.driver;
        this.port=di.port;
        this.host=di.host;
        this.user=di.user;
        this.password=di.password;
        this.hdiUser=di.hdiUser;
        this.hdiPassword=di.hdiPassword;
        this.url=di.url;
        this.certificate=di.certificate;
        this.tenantId=di.tenantId;
        this.id=di.id;
        this.statusAsText=di.statusAsText;
        this.dbKey=di.dbKey;
        this.databaseId=di.databaseId;
    }

    public String getSchema() {
        return schema;
    }

    public String getDriver() {
        return driver;
    }

    public String getPort() {
        return port;
    }

    public String getHost() {
        return host;
    }

    public String getUser() {
        return user;
    }

    public String getPassword() {
        return password;
    }

    public String getHdiUser() {
        return hdiUser;
    }

    public String getHdiPassword() {
        return hdiPassword;
    }

    public String getUrl() {
        return url;
    }

    public String getCertificate() {
        return certificate;
    }

    /**
     *
     * @param schema Database schema.
     */
    public void setSchema(String schema) {
        this.schema = schema;
    }

    /**
     *
     * @param driver Database driver name.
     */
    public void setDriver(String driver) {
        this.driver = driver;
    }

    /**
     *
     * @param port Database port.
     */
    public void setPort(String port) {
        this.port = port;
    }

    /**
     *
     * @param host Database host.
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     *
     * @param user Database user.
     */
    public void setUser(String user) {
        this.user = user;
    }

    /**
     *
     * @param password Database password.
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     *
     * @param hdiUser Only for HANA: user used for HDI operations.
     */
    public void setHdiUser(String hdiUser) {
        this.hdiUser = hdiUser;
    }

    /**
     *
     * @param hdiPassword Only for HANA: password of HDI user.
     */
    public void setHdiPassword(String hdiPassword) {
        this.hdiPassword = hdiPassword;
    }

    /**
     *
     * @param url Database url.
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     *
     * @param certificate Only for HANA: Database certificate
     */
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getTenantId() {
        return tenantId;
    }

    /**
     *
     * @param tenantId Tenant id of owner of schema/HDI container.
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return id;
    }

    /**
     *
     * @param id Identifier which was passed to create instance/schema, equal to tenant id
     */
    public void setId(String id) {
        this.id = id;
    }

    public String getStatusAsText() {
        return statusAsText;
    }

    /**
     *
     * @param statusAsText Status of created schema/HDI container as text.
     */
    public void setStatusAsText(String statusAsText) {
        this.statusAsText = statusAsText;
    }

    public String getDbKey() {
        return dbKey;
    }

    /**
     *
      * @param dbKey Unique key that identifies a database. Can be for example the database url or "host:port" .. . Used by the mt-lib
     *              to decide which tenants can be handled with the same connection pool. In mode oneDataSourcePerDb only one connection pool
     *              per DB is created.
     */
    public void setDbKey(String dbKey) {
        this.dbKey = dbKey;
    }

    public String getDatabaseId() {
        return databaseId;
    }

    /**
     *
     * @param databaseId Official DB dependent identifier of a database. Not necessarily unique. In case of HANA it is the HANA database id. For PostgreSQL it is
     *                   database attribute "database". The mt-libs build the names of its own schemas/instances by concatenation of a prefix with the
     *                   databaseId. In HANA case it is also needed to inform the service manager on which HANA DB the HDI container shall be created.
     */
    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }
}
