package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.exceptions.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class HanaEncryptionTool {
    private static final Logger logger = LoggerFactory.getLogger(HanaEncryptionTool.class);

    private HanaEncryptionTool() {
    }

    public static void addEncryptionParameter(ServiceCreateOptions serviceCreateOptions, DbEncryptionMode encryptionMode,
                                              SubscriptionPayloadAccess payloadAccess) throws InternalError {
        if (encryptionMode == null) {
            logger.debug("No Hana encryption mode specified");
            return;
        }
        logger.debug("Hana encryption mode {} specified", encryptionMode.getValue());
        if (serviceCreateOptions == null) {
            throw new InternalError("Instance create options is initial");
        }
        var parameters = new HashMap<String, Object>();
        if (serviceCreateOptions.getProvisioningParameters() != null) {
            parameters.putAll(serviceCreateOptions.getProvisioningParameters());
        }
        Map<String, String> dataEncryption = new HashMap<>();
        dataEncryption.put("mode", encryptionMode.getValue());
        parameters.put("dataEncryption", dataEncryption);
        Map<String, String> subscriptionContext = new HashMap<>();
        subscriptionContext.put("globalAccountID", payloadAccess.getGlobalAccountId());
        subscriptionContext.put("subAccountID", payloadAccess.getSubAccountId());
        subscriptionContext.put("applicationName", payloadAccess.getApplicationName());
        parameters.put("subscriptionContext", subscriptionContext);
        parameters.put("enableTenant", "true");
        serviceCreateOptions.withProvisioningParameters(parameters);
    }

    public enum DbEncryptionMode {
        DEDICATED_KEY("DEDICATED_KEY"), MANAGED_KEY("MANAGED_KEY"), AUTO_DETECT("AUTO_DETECT");
        private final String value;

        DbEncryptionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
