/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/

package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.exceptions.AuthorityError;

public interface SecurityChecker {
    public void checkSubscriptionAuthority() throws AuthorityError;

    public void checkInitDbAuthority() throws AuthorityError;

    public default void checkAuthority(Authority authority) throws AuthorityError {
        switch (authority) {
            case SUBSCRIBE, UNSUBSCRIBE:
                checkSubscriptionAuthority();
                break;
            case INIT_DB:
                checkInitDbAuthority();
                break;
        }
    }

    public enum Authority {
        SUBSCRIBE, UNSUBSCRIBE, INIT_DB;
    }
}
