/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.mt.subscription;


import com.sap.cloud.mt.tools.api.InstanceCreationOptions;

import java.util.Map;

public class ServiceCreateOptions {

    private Map<String, Object> provisioningParameters = null;
    private Map<String, Object> bindingParameters = null;

    public ServiceCreateOptions() {
    }

    public ServiceCreateOptions(InstanceCreationOptions instanceCreationOptions) {
        if (instanceCreationOptions != null) {
            this.provisioningParameters = instanceCreationOptions.getProvisioningParameters();
            this.bindingParameters = instanceCreationOptions.getBindingParameters();
        }
    }

    public Map<String, Object> getProvisioningParameters() {
        return provisioningParameters;
    }

    public ServiceCreateOptions withProvisioningParameters(Map<String, Object> provisioningParameters) {
        this.provisioningParameters = provisioningParameters;
        return this;
    }

    public Map<String, Object> getBindingParameters() {
        return bindingParameters;
    }

    public ServiceCreateOptions withBindingParameters(Map<String, Object> bindingParameters) {
        this.bindingParameters = bindingParameters;
        return this;
    }
}
