package com.sap.cloud.mt.subscription;

import java.util.Map;

public interface SubscriptionPayloadAccess {

    String getGlobalAccountId();

    String getSubAccountId();

    String getApplicationName();

    String getEventType();

    String getSubDomain();

    static SubscriptionPayloadAccess create(Map<String, Object> payload) {
        if (payload.containsKey("subscriber")) {
            return new SubscriptionPayloadAccessForSMS(payload);
        } else {
            return new SubscriptionPayloadAccessForSaasRegistry(payload);
        }
    }
}
