/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.subscription.exits;

public class Exits {
    private final UnSubscribeExit unSubscribeExit;
    private final SubscribeExit subscribeExit;
    private final DependencyExit dependencyExit;
    private final InitDbExit initDbExit;
    private final UserProvidedSchemasExit userProvidedSchemasExit;
    private final boolean callAsyncExits;

    public Exits(UnSubscribeExit unSubscribeExit, SubscribeExit subscribeExit, DependencyExit dependencyExit,
                 InitDbExit initDbExit, UserProvidedSchemasExit userProvidedSchemasExit,
                 boolean callAsyncExits) {
        this.callAsyncExits = callAsyncExits;
        this.unSubscribeExit = unSubscribeExit != null ? unSubscribeExit : new UnSubscribeExit() {
        };
        this.subscribeExit = subscribeExit != null ? subscribeExit : new SubscribeExit() {
        };
        this.dependencyExit = dependencyExit != null ? dependencyExit : new DependencyExit() {
        };
        this.initDbExit = initDbExit != null ? initDbExit : new InitDbExit() {
        };
        this.userProvidedSchemasExit = userProvidedSchemasExit;
    }

    public Exits(UnSubscribeExit unSubscribeExit, SubscribeExit subscribeExit, DependencyExit dependencyExit,
                 InitDbExit initDbExit) {
        this(unSubscribeExit, subscribeExit, dependencyExit, initDbExit, null, false);
    }

    public UnSubscribeExit getUnSubscribeExit() {
        return unSubscribeExit;
    }

    public SubscribeExit getSubscribeExit() {
        return subscribeExit;
    }

    public DependencyExit getDependencyExit() {
        return dependencyExit;
    }

    public InitDbExit getInitDbExit() {
        return initDbExit;
    }

    public UserProvidedSchemasExit getUserProvidedSchemasExit() {
        return userProvidedSchemasExit;
    }

    public BeforeSubscribeMethod getBeforeSubscribeMethod() {
        return callAsyncExits ? subscribeExit::onBeforeAsyncSubscribe : subscribeExit::onBeforeSubscribe;
    }

    public AfterSubscribeMethod getAfterSubscribeMethod() {
        return callAsyncExits ? subscribeExit::onAfterAsyncSubscribe : subscribeExit::onAfterSubscribe;
    }

    public BeforeUnSubscribeMethod getBeforeUnSubscribeMethod() {
        return callAsyncExits ? unSubscribeExit::onBeforeAsyncUnsubscribe : unSubscribeExit::onBeforeUnsubscribe;
    }

    public AfterUnSubscribeMethod getAfterUnSubscribeMethod() {
        return callAsyncExits ? unSubscribeExit::onAfterAsyncUnsubscribe : unSubscribeExit::onAfterUnsubscribe;
    }
}
