/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.subscription.exits;

import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.InstanceCreationOptions;

import java.net.URL;

public interface SubscribeExit {
    default InstanceCreationOptions onBeforeSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
        return null;
    }

    default InstanceCreationOptions onBeforeAsyncSubscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError {
        return null;
    }

    default void onAfterSubscribe(String tenantId, SubscriptionPayload subscriptionPayload, boolean wasSuccessful) {
    }

    default void onAfterAsyncSubscribe(String tenantId, SubscriptionPayload subscriptionPayload, boolean wasSuccessful) {
    }

    default URL uiURL() {
        return null;
    }

    default URL uiURL(SubscriptionPayload subscriptionPayload) {
        return null;
    }
}
