/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.subscription.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.exceptions.InternalError;

import java.io.IOException;

public class Cloner {
    private static final ObjectMapper mapper = new ObjectMapper();

    private Cloner() {
    }

    public static <T> T clone(T source) throws InternalError {
        if (source == null) return null;
        try {
            return (T) mapper.readValue(mapper.writeValueAsString(source), source.getClass());
        } catch (IOException e) {
            throw new InternalError("Could not convert between object and json", e);
        }
    }
}
