/******************************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved.            *
 ******************************************************************************/
package com.sap.cloud.mt.subscription.json;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)

public class SubscriptionPayload extends AbstractTenantLcmPayload {
    public static final String SUBSCRIPTION_PARAMS = "subscriptionParams";
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<Object, Object> subscriptionParams = new HashMap<>(); //NOSONAR
    public String subscribedLicenseType; //NOSONAR
    public String eventType;//NOSONAR
    public SubscriptionPayloadAddInfo additionalInformation;//NOSONAR

    public SubscriptionPayload() {
        super();
    }

    public SubscriptionPayload(Map<String, Object> map) {
        super(map);
    }

    @Override
    protected void fillAttributesFromMap() {
        super.fillAttributesFromMap();
        subscribedLicenseType = (String) map.get("subscribedLicenseType");
        eventType = (String) map.get("eventType");
        if (map.get("additionalInformation") != null) {
            var addInfoMap = (Map<String, Object>) map.get("additionalInformation");
            additionalInformation = new SubscriptionPayloadAddInfo();
            additionalInformation.clientid = (String) addInfoMap.get("clientid");
            additionalInformation.clientsecret = (String) addInfoMap.get("clientsecret");
            additionalInformation.tokenurl = (String) addInfoMap.get("tokenurl");
        }
        if (map.get(SUBSCRIPTION_PARAMS) != null && !((Map<Object, Object>) map.get(SUBSCRIPTION_PARAMS)).isEmpty()) {
            if (subscriptionParams == null) {
                subscriptionParams = new HashMap<>();
            }
            subscriptionParams.putAll((Map<Object, Object>) map.get(SUBSCRIPTION_PARAMS));
        }
    }
}
