/*
 * *************************************************************************
 *  * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *  *************************************************************************
 */

package com.sap.cloud.mt.subscription.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UserInfo {
    public String userId;//NOSONAR
    public String userName;//NOSONAR
    public String email;//NOSONAR
    public String subIdp;//NOSONAR
    public String sub;//NOSONAR

    public UserInfo() {
    }

    public UserInfo(UserInfo userInfo) {
        this.userId = userInfo.userId;
        this.userName = userInfo.userName;
        this.email = userInfo.email;
        this.subIdp = userInfo.subIdp;
        this.sub = userInfo.sub;
    }

    @Override
    public String toString() {
        return "UserInfo{" +
                "userId='" + userId + '\'' +
                ", userName='" + userName + '\'' +
                ", email='" + email + '\'' +
                ", subIdp='" + subIdp + '\'' +
                ", sub='" + sub + '\'' +
                '}';
    }
}
