/*
 * *************************************************************************
 *  * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 *  *************************************************************************
 */

package com.sap.cloud.mt.tools;

import java.time.Duration;
import java.util.function.Supplier;

public class Wait {
    private final Duration maximumTime;
    private final Duration waitTime;

    private Wait(Duration maximumTime, Duration waitTime) {
        this.maximumTime = maximumTime;
        this.waitTime = waitTime;
    }

    public static WaitBuilder createBuilder() {
        return WaitBuilder.create();
    }

    public void waitUntil(Supplier<Boolean> until) {
        long startTime = System.currentTimeMillis();
        if (until.get()) {
            return;
        }
        do {
            try {
                Thread.sleep(waitTime.toMillis());
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!until.get() && System.currentTimeMillis() - startTime <= maximumTime.toMillis());
    }

    public static final class WaitBuilder {
        private Duration maximumTime;
        private Duration waitTime;

        private WaitBuilder() {
        }

        private static WaitBuilder create() {
            return new WaitBuilder();
        }

        public WaitBuilder maximumTime(Duration maximumTime) {
            this.maximumTime = maximumTime;
            return this;
        }

        public WaitBuilder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Wait build() {
            return new Wait(maximumTime, waitTime);
        }
    }
}
