/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqLiteFileResolver {
    private static final Logger logger = LoggerFactory.getLogger(SqLiteFileResolver.class);
    private static final Pattern SQLITE_FILE_NAME = Pattern.compile("sqlite[_|-]([\\w-]+)\\.db");
    private static final Pattern SQLITE_ALTERNATIVE_FILE_NAME = Pattern.compile("db[_|-]([\\w-]+)\\.sqlite");
    private final List<String> directories = Arrays.asList("mtx/sidecar/gen", "mtx/sidecar/", "../mtx/sidecar/", "../mtx/sidecar/gen", ".", "../");
    private final Path root;

    public SqLiteFileResolver(Path root) {
        this.root = root;
    }

    public Map<String, Path> get() {
        for (String variant : this.directories) {
            Path path = this.root.resolve(variant);
            Map<String, Path> result = SqLiteFileResolver.find(path);
            if (result.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Picked up tenants: {}", (Object)String.join((CharSequence)", ", result.keySet()));
            }
            return result;
        }
        logger.debug("No tenant databases found.");
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Path> find(Path root) {
        try (Stream<Path> stream = Files.find(root, 1, (path, attributes) -> attributes.isRegularFile() && SqLiteFileResolver.isFileUsable(path.toFile()), FileVisitOption.FOLLOW_LINKS);){
            List<Path> potentialFiles = stream.toList();
            if (potentialFiles.isEmpty()) return Collections.emptyMap();
            HashMap result = new HashMap();
            potentialFiles.forEach(item -> {
                SqLiteFileResolver.ifMatch(item.getFileName().toString(), SQLITE_ALTERNATIVE_FILE_NAME, matcher -> result.putIfAbsent(matcher.group(1), item));
                SqLiteFileResolver.ifMatch(item.getFileName().toString(), SQLITE_FILE_NAME, matcher -> result.putIfAbsent(matcher.group(1), item));
            });
            logger.debug("Found {} tenant databases at {}", (Object)result.size(), (Object)root);
            Map<String, Path> map = Collections.unmodifiableMap(result);
            return map;
        }
        catch (NoSuchFileException e) {
            logger.debug("Skipped missing path at {}", (Object)e.getFile());
            return Collections.emptyMap();
        }
        catch (IOException e) {
            logger.error("There was an error during file access. No tenants will be returned", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private static boolean isFileUsable(File file) {
        return file.exists() && file.canRead() && file.canWrite() && (SQLITE_FILE_NAME.matcher(file.getName()).matches() || SQLITE_ALTERNATIVE_FILE_NAME.matcher(file.getName()).matches());
    }

    private static void ifMatch(String text, Pattern pattern, Consumer<Matcher> action) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            action.accept(matcher);
        }
    }
}

