/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbCredentialsH2;
import com.sap.cloud.mt.subscription.DbCredentialsPostgreSQL;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DbCredentialsBuilder {
    private static final String DBNAME = "dbname";
    private static final String DATABASE = "database";
    private static final String URI = "uri";
    private static final String JDBC = "jdbc:";
    private static final String POSTGRES = "postgres:";
    private static final String POSTGRESQL = "postgresql:";
    private static final String H2 = "h2";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String HOSTNAME = "hostname";
    private static final String PORT = "port";
    private Map<String, Object> credentials = new HashMap<String, Object>();
    DbIdentifiers.DB db = DbIdentifiers.DB.NONE;

    private DbCredentialsBuilder() {
    }

    public DbCredentials build() throws InternalError {
        switch (this.db) {
            case POSTGRESQL: {
                return this.createPostgresCredentials();
            }
            case H2: {
                return this.createH2Credentials();
            }
        }
        throw new InternalError("Don't support this DB");
    }

    public static DbCredentialsBuilder create() {
        return new DbCredentialsBuilder();
    }

    public DbCredentialsBuilder db(DbIdentifiers.DB db) {
        if ((this.db == null || this.db == DbIdentifiers.DB.NONE) && db != null && db != DbIdentifiers.DB.NONE) {
            this.db = db;
        }
        return this;
    }

    public DbCredentialsBuilder credentials(Map<String, Object> credentials) {
        this.credentials = new HashMap<String, Object>(credentials);
        this.setDbType(credentials);
        return this;
    }

    private void setDbType(Map<String, Object> credentials) {
        String uri;
        if (credentials.containsKey(URI) && StringUtils.isNotEmpty((CharSequence)(uri = (String)credentials.get(URI)))) {
            if (this.isDbType(uri, POSTGRES, POSTGRESQL)) {
                this.db = DbIdentifiers.DB.POSTGRESQL;
            } else if (this.isDbType(uri, H2)) {
                this.db = DbIdentifiers.DB.H2;
            }
        }
    }

    private boolean isDbType(String uri, String ... dbStartString) {
        return Arrays.stream(dbStartString).anyMatch(start -> uri.startsWith(JDBC + start) || uri.startsWith((String)start));
    }

    private DbCredentials createPostgresCredentials() throws InternalError {
        DbCredentialsPostgreSQL credentialsPostgreSQL;
        String username = (String)this.credentials.get(USERNAME);
        String password = (String)this.credentials.get(PASSWORD);
        String hostname = (String)this.credentials.get(HOSTNAME);
        String port = (String)this.credentials.get(PORT);
        String uri = (String)this.credentials.get(URI);
        String database = null;
        if (this.credentials.containsKey(DBNAME)) {
            database = (String)this.credentials.get(DBNAME);
        }
        if (this.credentials.containsKey(DATABASE)) {
            database = (String)this.credentials.get(DATABASE);
        }
        if (StringUtils.isEmpty((CharSequence)(credentialsPostgreSQL = new DbCredentialsPostgreSQL(username, password, hostname, port, database, uri)).getUser())) {
            throw new InternalError("No DB user specified");
        }
        if (StringUtils.isEmpty((CharSequence)credentialsPostgreSQL.getPassword())) {
            throw new InternalError("No DB password specified");
        }
        if (StringUtils.isEmpty((CharSequence)credentialsPostgreSQL.getUrl()) && StringUtils.isEmpty((CharSequence)credentialsPostgreSQL.getHost())) {
            throw new InternalError("No DB uri and host specified");
        }
        return credentialsPostgreSQL;
    }

    private DbCredentials createH2Credentials() throws InternalError {
        DbCredentialsH2 credentialsH2;
        String username = (String)this.credentials.get(USERNAME);
        String password = (String)this.credentials.get(PASSWORD);
        String database = null;
        if (this.credentials.containsKey(DBNAME)) {
            database = (String)this.credentials.get(DBNAME);
        }
        if (this.credentials.containsKey(DATABASE)) {
            database = (String)this.credentials.get(DATABASE);
        }
        if (StringUtils.isEmpty((CharSequence)(credentialsH2 = new DbCredentialsH2(username, password, database)).getUser())) {
            throw new InternalError("No DB user specified");
        }
        return credentialsH2;
    }
}

