/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DbCredentialsPostgreSQL
extends DbCredentials {
    private static final String URL_TEMPLATE = "jdbc:postgresql://{host}:{port}/{database}";
    private static final String URL_TEMPLATE_WITHOUT_PORT = "jdbc:postgresql://{host}/{database}";
    private static final String ORG_POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private final String database;

    public DbCredentialsPostgreSQL(String user, String password, String host, String port, String database, String uriStr) throws InternalError {
        super(user, password, host, port, ORG_POSTGRESQL_DRIVER, uriStr != null ? uriStr.replace("postgres:", "postgresql:") : "");
        this.database = database;
    }

    public DbCredentialsPostgreSQL(DbCredentialsPostgreSQL dbCredentials) {
        super(dbCredentials);
        this.database = dbCredentials.database;
    }

    @Override
    public String getDatabaseId() {
        if (StringUtils.isNotEmpty((CharSequence)this.database)) {
            return this.database;
        }
        if (this.uri == null) {
            return "";
        }
        String path = this.uri.getPath();
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return path.substring(1);
        }
        return "";
    }

    @Override
    protected String buildUrl() {
        if (StringUtils.isNotEmpty((CharSequence)this.getPort())) {
            return URL_TEMPLATE.replace("{host}", this.getHost()).replace("{port}", this.getPort()).replace("{database}", this.getDatabaseId());
        }
        return URL_TEMPLATE_WITHOUT_PORT.replace("{host}", this.getHost()).replace("{database}", this.getDatabaseId());
    }

    @Override
    public DbIdentifiers.DB getDB() {
        return DbIdentifiers.DB.POSTGRESQL;
    }

    @Override
    public DbCredentials createCopy() {
        return new DbCredentialsPostgreSQL(this);
    }

    @Override
    protected List<DbCredentials.HostAndPort> getHostsFromUri(URI uri) {
        ArrayList<DbCredentials.HostAndPort> hostAndPorts = new ArrayList<DbCredentials.HostAndPort>();
        String authority = uri.getAuthority();
        if (StringUtils.isEmpty((CharSequence)authority)) {
            return hostAndPorts;
        }
        String hostsStr = this.optionalADividerB_getB("@", authority);
        String[] hosts = hostsStr.split(",", 0);
        Arrays.stream(hosts).forEach(h -> {
            DbCredentials.HostAndPort hostAndPort = new DbCredentials.HostAndPort();
            hostAndPort.host = this.aDividerOptionalB_getA(":", (String)h);
            hostAndPort.port = this.aDividerOptionalB_getB(":", (String)h);
            hostAndPorts.add(hostAndPort);
        });
        return hostAndPorts;
    }

    @Override
    protected DbCredentials.UserAndPassword getUserFromUri(URI uri) {
        DbCredentials.UserAndPassword userAndPassword = new DbCredentials.UserAndPassword();
        userAndPassword.user = "";
        userAndPassword.password = "";
        String authority = uri.getAuthority();
        if (StringUtils.isEmpty((CharSequence)authority)) {
            return userAndPassword;
        }
        String userStr = this.optionalADividerB_getA("@", authority);
        userAndPassword.user = this.aDividerOptionalB_getA(":", userStr);
        userAndPassword.password = this.aDividerOptionalB_getB(":", userStr);
        return userAndPassword;
    }

    private String optionalADividerB_getA(String divider, String str) {
        if (!str.contains(divider)) {
            return "";
        }
        String[] components = str.split(divider, 2);
        return components[0];
    }

    private String optionalADividerB_getB(String divider, String str) {
        if (!str.contains(divider)) {
            return str;
        }
        String[] components = str.split(divider, 2);
        return components[1];
    }

    private String aDividerOptionalB_getA(String divider, String str) {
        if (!str.contains(divider)) {
            return str;
        }
        String[] components = str.split(divider, 2);
        return components[0];
    }

    private String aDividerOptionalB_getB(String divider, String str) {
        if (!str.contains(divider)) {
            return "";
        }
        String[] components = str.split(divider, 2);
        return components[1];
    }
}

