/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.ServiceCreateOptions;
import com.sap.cloud.mt.subscription.SubscriptionPayloadAccess;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaEncryptionTool {
    private static final Logger logger = LoggerFactory.getLogger(HanaEncryptionTool.class);

    private HanaEncryptionTool() {
    }

    public static void addEncryptionParameter(ServiceCreateOptions serviceCreateOptions, DbEncryptionMode encryptionMode, SubscriptionPayloadAccess payloadAccess) throws InternalError {
        if (encryptionMode == null) {
            logger.debug("No Hana encryption mode specified");
            return;
        }
        logger.debug("Hana encryption mode {} specified", (Object)encryptionMode.getValue());
        if (serviceCreateOptions == null) {
            throw new InternalError("Instance create options is initial");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (serviceCreateOptions.getProvisioningParameters() != null) {
            parameters.putAll(serviceCreateOptions.getProvisioningParameters());
        }
        HashMap<String, String> dataEncryption = new HashMap<String, String>();
        dataEncryption.put("mode", encryptionMode.getValue());
        parameters.put("dataEncryption", dataEncryption);
        HashMap<String, String> subscriptionContext = new HashMap<String, String>();
        subscriptionContext.put("globalAccountID", payloadAccess.getGlobalAccountId());
        subscriptionContext.put("subAccountID", payloadAccess.getSubAccountId());
        subscriptionContext.put("applicationName", payloadAccess.getApplicationName());
        parameters.put("subscriptionContext", subscriptionContext);
        parameters.put("enableTenant", "true");
        serviceCreateOptions.withProvisioningParameters(parameters);
    }

    public static enum DbEncryptionMode {
        DEDICATED_KEY("DEDICATED_KEY"),
        MANAGED_KEY("MANAGED_KEY"),
        AUTO_DETECT("AUTO_DETECT");

        private final String value;

        private DbEncryptionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

