/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.BindingParameters;
import com.sap.cloud.mt.subscription.DataSourceInfo;
import com.sap.cloud.mt.subscription.DataSourceInfoBuilder;
import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersSql;
import com.sap.cloud.mt.subscription.FilterTenants;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.ProvisioningParameters;
import com.sap.cloud.mt.subscription.SqlOperations;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.UnknownTenant;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLifecycleManagerSqlDb
implements InstanceLifecycleManager {
    protected static final String SCHEMA_PREFIX = "MT-";
    private static Logger logger = LoggerFactory.getLogger(InstanceLifecycleManagerSqlDb.class);
    private DbIdentifiersSql dbIdentifiers;
    private final SqlOperations sqlOperations;
    private static final ConcurrentHashMap<String, Mutex> tenantToMutex = new ConcurrentHashMap();
    private final DbIdentifiers.DB db;

    public InstanceLifecycleManagerSqlDb(DbIdentifiersSql dbIdentifiers) throws InternalError {
        if (dbIdentifiers == null || !dbIdentifiers.areSet()) {
            throw new InternalError("No databases specified");
        }
        this.dbIdentifiers = dbIdentifiers;
        this.sqlOperations = SqlOperations.build(dbIdentifiers.getDB());
        this.db = dbIdentifiers.getDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewInstance(String tenantId, ProvisioningParameters provisioningParameters, BindingParameters bindingParameters) throws InternalError {
        Mutex mutex = InstanceLifecycleManagerSqlDb.getMutex(tenantId);
        synchronized (mutex) {
            Optional<DbCredentials> credentials;
            if (this.doesTenantExist(tenantId)) {
                return;
            }
            String databaseId = null;
            if (provisioningParameters != null) {
                databaseId = provisioningParameters.getDatabaseId();
            }
            if (!(credentials = databaseId != null ? this.dbIdentifiers.getCredentials(databaseId) : this.dbIdentifiers.getLast()).isPresent()) {
                throw new InternalError("No database credentials available for database ID " + databaseId);
            }
            try {
                DbCredentials cred = credentials.get();
                try (Connection connection = this.getConnection(cred);){
                    this.sqlOperations.createSchema(this.getSchemaName(tenantId), connection);
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
            }
            catch (SQLException e) {
                throw new InternalError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        Mutex mutex = InstanceLifecycleManagerSqlDb.getMutex(tenantId);
        synchronized (mutex) {
            Optional<DbCredentials> credentials = this.getCredentials(tenantId);
            if (!credentials.isPresent()) {
                logger.warn("No schema for tenant {} found", (Object)tenantId);
                return;
            }
            try (Connection connection = this.getConnection(credentials.get());){
                this.sqlOperations.deleteSchema(this.getSchemaName(tenantId), connection);
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                throw new InternalError(e);
            }
        }
    }

    @Override
    public DataSourceInfo getDataSourceInfo(String tenantId, boolean forceCacheUpdate) throws InternalError, UnknownTenant {
        Optional<DbCredentials> credentials = this.getCredentials(tenantId);
        if (!credentials.isPresent()) {
            throw new UnknownTenant("No schema found for tenant " + tenantId);
        }
        DbCredentials cred = credentials.get();
        return DataSourceInfoBuilder.createBuilder().driver(cred.getDriver()).host(cred.getHost()).port(cred.getPort()).user(cred.getUser()).password(cred.getPassword()).statusAsText("ok").url(cred.getUrl()).schema(this.getSchemaName(tenantId)).tenantId(tenantId).id(tenantId).dbKey(cred.getUrl()).databaseId(cred.getDatabaseId()).build();
    }

    @Override
    public InstanceLifecycleManager.ContainerStatus getContainerStatus(String tenantId) throws InternalError {
        if (!this.doesTenantExist(tenantId)) {
            return InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST;
        }
        return InstanceLifecycleManager.ContainerStatus.OK;
    }

    @Override
    public boolean hasCredentials(String tenantId, boolean forceCacheUpdate) throws InternalError {
        return this.getContainerStatus(tenantId).equals((Object)InstanceLifecycleManager.ContainerStatus.OK);
    }

    @Override
    public Map<String, TenantMetadata> getAllTenantInfos(boolean forceCacheUpdate) throws InternalError {
        HashMap<String, TenantMetadata> tenants = new HashMap<String, TenantMetadata>();
        ArrayList credentialsWithError = new ArrayList();
        ArrayList sqlExceptions = new ArrayList();
        this.dbIdentifiers.asStream().forEach(cred -> {
            try (Connection connection = this.getConnection((DbCredentials)cred);){
                this.sqlOperations.getAllSchemas(connection).stream().filter(s -> s.startsWith(SCHEMA_PREFIX)).map(s -> {
                    TenantMetadata tenantInfo = new TenantMetadata(s.replace(SCHEMA_PREFIX, ""));
                    if (cred.getDatabaseId() != null) {
                        tenantInfo.putAdditionalProperty("database_id", cred.getDatabaseId());
                    }
                    return tenantInfo;
                }).filter(tenantInfo -> FilterTenants.realTenants().test(tenantInfo.getTenantId())).forEach(t -> tenants.put(t.getTenantId(), (TenantMetadata)t));
            }
            catch (SQLException e) {
                logger.error("Cannot access database {} because of {}", (Object)cred.getUrl(), (Object)e.getMessage());
                sqlExceptions.add(e);
                credentialsWithError.add(cred);
            }
        });
        if (!sqlExceptions.isEmpty()) {
            throw new InternalError("Cannot access database " + ((DbCredentials)credentialsWithError.get(0)).getUrl(), (Throwable)sqlExceptions.get(0));
        }
        return tenants;
    }

    @Override
    public void checkThatTenantExists(String tenantId) throws UnknownTenant {
        try {
            if (!this.doesTenantExist(tenantId)) {
                throw new UnknownTenant("No schema for tenant " + tenantId);
            }
        }
        catch (InternalError internalError) {
            throw new UnknownTenant(internalError, "Could not access DB.");
        }
    }

    @Override
    public List<DataSourceInfo> createAndGetLibContainers(DataSourceInfo dataSourceInfo) throws InternalError {
        ArrayList internalErrors = new ArrayList();
        this.dbIdentifiers.asStream().forEach(cred -> {
            block5: {
                String mtLibTenantId = this.getMtLibContainerName(cred.getDatabaseId());
                try {
                    if (this.doesTenantExist(mtLibTenantId)) break block5;
                    Mutex mutex = InstanceLifecycleManagerSqlDb.getMutex(mtLibTenantId);
                    synchronized (mutex) {
                        this.createNewInstance(mtLibTenantId, this.createProvisioningParameters(cred.getDatabaseId()), new BindingParameters());
                    }
                }
                catch (InternalError internalError) {
                    logger.error("Could not access DB with {}, error is {}", (Object)cred.getUrl(), (Object)internalError.getMessage());
                    internalErrors.add(internalError);
                }
            }
        });
        if (!internalErrors.isEmpty()) {
            throw (InternalError)internalErrors.get(0);
        }
        return this.getLibContainers();
    }

    @Override
    public List<DataSourceInfo> getLibContainers() throws InternalError {
        ArrayList internalErrors = new ArrayList();
        ArrayList<DataSourceInfo> dsInfo = new ArrayList<DataSourceInfo>();
        this.dbIdentifiers.asStream().forEach(cred -> {
            String mtLibTenantId = this.getMtLibContainerName(cred.getDatabaseId());
            try {
                if (!this.doesTenantExist(mtLibTenantId)) {
                    return;
                }
                try {
                    dsInfo.add(this.getDataSourceInfo(mtLibTenantId, true));
                }
                catch (InternalError | UnknownTenant error) {
                    logger.error("Could not retrieve credentials for schema {}", (Object)mtLibTenantId);
                    internalErrors.add(new InternalError(error));
                }
            }
            catch (InternalError internalError) {
                logger.error("Could not access DB with {}, error is {}", (Object)cred.getUrl(), (Object)internalError.getMessage());
                internalErrors.add(internalError);
            }
        });
        if (!internalErrors.isEmpty()) {
            throw (InternalError)internalErrors.get(0);
        }
        return dsInfo;
    }

    private Connection getConnection(DbCredentials cred) throws SQLException {
        return DriverManager.getConnection(cred.getUrl(), cred.getUser(), cred.getPassword());
    }

    private boolean doesTenantExist(String tenantId) throws InternalError {
        Optional<DbCredentials> credentials = this.getCredentials(tenantId);
        return credentials.isPresent();
    }

    private Optional<DbCredentials> getCredentials(String tenantId) throws InternalError {
        ArrayList errors = new ArrayList();
        Optional<DbCredentials> credentials = this.dbIdentifiers.asStream().filter(cred -> {
            boolean bl;
            block8: {
                Connection connection = this.getConnection((DbCredentials)cred);
                try {
                    bl = this.sqlOperations.doesSchemaExist(this.getSchemaName(tenantId), connection);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        logger.error("Could not access DB {}", (Object)cred.getUrl());
                        errors.add(new InternalError(e));
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        }).findFirst();
        if (!errors.isEmpty()) {
            throw new InternalError((Throwable)errors.get(0));
        }
        return credentials;
    }

    private String getSchemaName(String tenantId) {
        return SCHEMA_PREFIX + tenantId;
    }

    private static Mutex getMutex(String tenantId) {
        Mutex mutex = tenantToMutex.get(tenantId);
        if (mutex != null) {
            return mutex;
        }
        Mutex newMutex = new Mutex();
        Mutex storedMutex = tenantToMutex.putIfAbsent(tenantId, newMutex);
        if (storedMutex != null) {
            return storedMutex;
        }
        return newMutex;
    }

    @Override
    public void insertDbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIdentifiers = (DbIdentifiersSql)dbIdentifiers;
    }

    protected DbIdentifiers getDbIdentifiers() {
        return this.dbIdentifiers.createCopy();
    }

    @Override
    public boolean hasDbIdentifiers() {
        return this.dbIdentifiers != null && this.dbIdentifiers.areSet();
    }

    @Override
    public DbIdentifiers.DB getDbType() {
        return this.db;
    }

    private static class Mutex {
        private Mutex() {
        }
    }
}

