/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.ServiceCreateOptions;
import com.sap.cloud.mt.subscription.ServiceSpecification;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.cloud.mt.tools.api.CodeTools;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.exception.ServiceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningService {
    public static final String MTX_PROVISIONING_SERVICE_DESTINATION = "com.sap.cds.mtxSidecar";
    private static final Logger logger = LoggerFactory.getLogger(ProvisioningService.class);
    private static final String PROVISIONING_ENDPOINT = "/-/cds/saas-provisioning/tenant/";
    private static final String UPGRADE_ENDPOINT = "/-/cds/saas-provisioning/upgrade";
    private static final String JOB_STATUS_ENDPOINT = "/-/cds/jobs/";
    private static final String UNEXPECTED_RETURN_CODE = "Unexpected return code ";
    private static final String PREFER = "prefer";
    private static final String RESPOND_ASYNC = "respond-async";
    private final Set<Integer> retryCodes = new HashSet<Integer>();
    private final ServiceEndpoint statusEndpoint;
    private final ServiceEndpoint subscribeEndpoint;
    private final ServiceEndpoint unsubscribeEndpoint;
    private final ServiceEndpoint upgradeEndpoint;
    private final ServiceSpecification serviceSpecification;

    public ProvisioningService(ServiceSpecification serviceSpecification) throws InternalError {
        this.serviceSpecification = serviceSpecification;
        this.retryCodes.add(502);
        this.retryCodes.add(504);
        this.retryCodes.add(500);
        this.retryCodes.add(503);
        try {
            this.statusEndpoint = ServiceEndpoint.create().destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(JOB_STATUS_ENDPOINT).returnCodeChecker(c -> {
                if (c == 404) {
                    return new NotFound("Job id not known");
                }
                if (c != 200) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.subscribeEndpoint = ServiceEndpoint.create().destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.unsubscribeEndpoint = ServiceEndpoint.create().destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(PROVISIONING_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200, 204})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(serviceSpecification.getResilienceConfig()).end();
            this.upgradeEndpoint = ServiceEndpoint.create().destinationName(MTX_PROVISIONING_SERVICE_DESTINATION).path(UPGRADE_ENDPOINT).returnCodeChecker(c -> {
                if (CodeTools.code((Object)c).notIn((Object[])new Integer[]{202, 200, 204})) {
                    return new InternalError(UNEXPECTED_RETURN_CODE + c);
                }
                return null;
            }).retry().forReturnCodes(this.retryCodes).config(serviceSpecification.getResilienceConfig()).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public Map<String, Object> determineJobStatus(String jobId) throws InternalError, NotFound {
        ServiceCall getStatus = null;
        try {
            getStatus = this.statusEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(String.format("pollJob(ID='%s')", jobId)).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).end();
            logger.debug("Call mtx determine status service with jobId {}", (Object)jobId);
            ServiceResponse response = getStatus.execute(Map.class);
            return response.getPayload().orElse(new HashMap());
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InternalError) {
                InternalError internalError = (InternalError)throwable;
                throw internalError;
            }
            throwable = e.getCause();
            if (throwable instanceof NotFound) {
                NotFound notFound = (NotFound)throwable;
                throw notFound;
            }
            throw new InternalError(e);
        }
    }

    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload, ServiceCreateOptions serviceCreateOptions) throws InternalError {
        Map<String, Object> sidecarPayload = Tools.getProvisioningServicePayload(subscriptionPayload, serviceCreateOptions);
        try {
            ServiceCall subscribe = this.subscribeEndpoint.createServiceCall().http().put().payload(sidecarPayload).pathParameter(tenantId).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(this.getHeaderFieldsForAsyncCall(true)).end();
            logger.debug("Call mtx provisioning service method subscribe for tenant {}", (Object)tenantId);
            ServiceResponse response = subscribe.execute(String.class);
            return MtxTools.extractJobId((ServiceResponse<String>)response);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InternalError) {
                InternalError internalError = (InternalError)throwable;
                throw internalError;
            }
            throw new InternalError(e);
        }
    }

    public String unsubscribe(String tenantId, DeletePayload deletePayload) throws InternalError {
        HashMap sidecarPayload = deletePayload != null ? deletePayload.getMap() : new HashMap();
        try {
            ServiceCall unsubscribe = this.unsubscribeEndpoint.createServiceCall().http().delete().payload(sidecarPayload).pathParameter(tenantId).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(this.getHeaderFieldsForAsyncCall(true)).end();
            logger.debug("Call mtx provisioning service method unsubscribe for tenant {}", (Object)tenantId);
            ServiceResponse response = unsubscribe.execute(String.class);
            return MtxTools.extractJobId((ServiceResponse<String>)response);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InternalError) {
                InternalError internalError = (InternalError)throwable;
                throw internalError;
            }
            throw new InternalError(e);
        }
    }

    public Map<String, Object> upgrade(Set<String> tenantIds, boolean asynchronously) throws InternalError {
        HashMap<String, Set<String>> upgradePayload = new HashMap<String, Set<String>>();
        if (tenantIds != null && !tenantIds.isEmpty()) {
            upgradePayload.put("tenants", tenantIds);
        }
        try {
            ServiceCall upgrade = this.upgradeEndpoint.createServiceCall().http().post().payload(upgradePayload).noPathParameter().noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(this.getHeaderFieldsForAsyncCall(asynchronously)).end();
            logger.debug("Call mtx provisioning service method upgrade all for tenants {}", tenantIds);
            ServiceResponse response = upgrade.execute(Map.class);
            return response.getPayload().orElse(new HashMap());
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InternalError) {
                InternalError internalError = (InternalError)throwable;
                throw internalError;
            }
            throw new InternalError(e);
        }
    }

    private Map<String, String> getHeaderFieldsForAsyncCall(boolean asynchronous) {
        HashMap<String, String> headerFields = new HashMap<String, String>();
        if (asynchronous) {
            headerFields.put(PREFER, RESPOND_ASYNC);
        }
        return headerFields;
    }

    public ServiceSpecification getServiceSpecification() {
        return this.serviceSpecification;
    }
}

