/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.HanaEncryptionTool;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.MtxTools;
import com.sap.cloud.mt.subscription.ProvisioningService;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.SecurityChecker;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.Tools;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.exits.Exits;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberStreamlinedMtx
implements Subscriber {
    public static final String ALL_TENANTS = "all";
    private static final Logger logger = LoggerFactory.getLogger(SubscriberStreamlinedMtx.class);
    private static final String NO_SAAS_REGISTRY_PROVIDED = "No saas registry provided";
    private static final String ID = "ID";
    private final Exits exits;
    private final SecurityChecker securityChecker;
    private final Optional<SaasRegistry> saasRegistry;
    private final ProvisioningService provisioningService;
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final MtxTools mtxTools;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final boolean withoutAuthorityCheck;

    private SubscriberStreamlinedMtx(Exits exits, String baseUiUrl, String urlSeparator, SecurityChecker securityChecker, SaasRegistry saasRegistry, ProvisioningService provisioningService, InstanceLifecycleManager instanceLifecycleManager, boolean withoutAuthorityCheck, HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) throws InternalError {
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        this.exits = exits;
        this.saasRegistry = Optional.ofNullable(saasRegistry);
        this.instanceLifecycleManager = instanceLifecycleManager;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.mtxTools = new MtxTools(securityChecker, baseUiUrl, urlSeparator, provisioningService.getServiceSpecification().getPolling(), hanaEncryptionMode);
        this.provisioningService = provisioningService;
        this.withoutAuthorityCheck = withoutAuthorityCheck;
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        return this.mtxTools.subscribe(tenantId, instanceCreationOptions -> this.provisioningService.subscribe(tenantId, subscriptionPayload, instanceCreationOptions), this.provisioningService::determineJobStatus, subscriptionPayload, this.withoutAuthorityCheck, this.exits);
    }

    @Override
    public String getSubscribeUrl(SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return Tools.getApplicationUrl(subscriptionPayload, this.exits.getSubscribeExit()::uiURL, this.exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload) throws InternalError, ParameterError, AuthorityError {
        this.mtxTools.unsubscribe(tenantId, () -> this.provisioningService.unsubscribe(tenantId, deletePayload), this.provisioningService::determineJobStatus, deletePayload, this.withoutAuthorityCheck, this.exits);
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies() throws AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return this.exits.getDependencyExit() != null ? this.exits.getDependencyExit().onGetDependencies() : new ArrayList();
    }

    @Override
    public void setupDbTables(List<String> tenants) throws InternalError, AuthorityError, ParameterError {
        this.setupDbTables(tenants, false);
    }

    @Override
    public String setupDbTablesAsync(List<String> tenants) throws InternalError, AuthorityError, ParameterError {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.setupDbTables(tenants, true));
        }
        catch (JsonProcessingException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public String updateStatus(String jobId) throws InternalError, ParameterError, NotFound, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        if (StringUtils.isBlank((CharSequence)jobId)) {
            logger.warn("An empty jobId was provided");
            return "{}";
        }
        if (!jobId.matches("^[_a-zA-Z0-9\\-]+$")) {
            throw new ParameterError("Job id contains illegal characters");
        }
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.provisioningService.determineJobStatus(jobId));
        }
        catch (JsonProcessingException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public void callSaasRegistry(boolean ok, String message, String applicationUrl, String saasRegistryUrl) throws InternalError {
        this.saasRegistry.orElseThrow(() -> new InternalError(NO_SAAS_REGISTRY_PROVIDED)).callBackSaasRegistry(ok, message, applicationUrl, saasRegistryUrl);
    }

    @Override
    public void checkAuthority(SecurityChecker.Authority authority) throws AuthorityError {
        this.securityChecker.checkAuthority(authority);
    }

    private Map<String, Object> setupDbTables(List<String> tenants, boolean asynchronously) throws InternalError, AuthorityError, ParameterError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        Tools.checkExternalTenantIds(tenants);
        if (tenants.isEmpty()) {
            return new HashMap<String, Object>();
        }
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onBeforeInitDb(tenants);
        }
        Set<String> tenantSet = new HashSet<String>(tenants);
        try {
            if (tenantSet.size() == 1 && tenants.get(0).equals(ALL_TENANTS)) {
                Set<String> allTenants = this.instanceLifecycleManager.getAllTenants(true);
                if (allTenants.isEmpty()) {
                    return new HashMap<String, Object>();
                }
                tenantSet = allTenants;
            }
            Map<String, Object> result = this.provisioningService.upgrade(tenantSet, asynchronously);
            if (!asynchronously && this.exits.getInitDbExit() != null) {
                this.exits.getInitDbExit().onAfterInitDb(true);
            }
            if (result.containsKey(ID)) {
                result.put("jobID", result.get(ID));
            }
            return result;
        }
        catch (InternalError e) {
            if (!asynchronously && this.exits.getInitDbExit() != null) {
                this.exits.getInitDbExit().onAfterInitDb(false);
            }
            throw e;
        }
    }

    public static final class Builder {
        private Exits exits;
        private SecurityChecker securityChecker;
        private SaasRegistry saasRegistry;
        private String baseUiUrl;
        private String urlSeparator;
        private ProvisioningService provisioningService;
        private InstanceLifecycleManager instanceLifecycleManager;
        private boolean withoutAuthorityCheck;
        private HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder exits(Exits exits) {
            this.exits = exits;
            return this;
        }

        public Builder securityChecker(SecurityChecker securityChecker) {
            this.securityChecker = securityChecker;
            return this;
        }

        public Builder saasRegistry(SaasRegistry saasRegistry) {
            this.saasRegistry = saasRegistry;
            return this;
        }

        public Builder provisioningService(ProvisioningService provisioningService) {
            this.provisioningService = provisioningService;
            return this;
        }

        public Builder baseUiUrl(String baseUiUrl) {
            this.baseUiUrl = baseUiUrl;
            return this;
        }

        public Builder urlSeparator(String urlSeparator) {
            this.urlSeparator = urlSeparator;
            return this;
        }

        public Builder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
            this.instanceLifecycleManager = instanceLifecycleManager;
            return this;
        }

        public Builder withoutAuthorityCheck(boolean withoutAuthorityCheck) {
            this.withoutAuthorityCheck = withoutAuthorityCheck;
            return this;
        }

        public Builder hanaEncryptionMode(HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) {
            this.hanaEncryptionMode = hanaEncryptionMode;
            return this;
        }

        public SubscriberStreamlinedMtx build() throws InternalError {
            if (this.provisioningService == null) {
                throw new InternalError("No provisioning service provided");
            }
            if (this.exits == null) {
                throw new InternalError("No exits provided");
            }
            if (this.securityChecker == null) {
                throw new InternalError("No security checker provided");
            }
            if (this.instanceLifecycleManager == null) {
                throw new InternalError("No instance lifecycle manager provided");
            }
            return new SubscriberStreamlinedMtx(this.exits, this.baseUiUrl, this.urlSeparator, this.securityChecker, this.saasRegistry, this.provisioningService, this.instanceLifecycleManager, this.withoutAuthorityCheck, this.hanaEncryptionMode);
        }
    }
}

