/*
 * ----------------------------------------------------------------
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.api;

public class AsyncCallResult {
    private final Exception exception;

    public AsyncCallResult(Exception exception) {
        this.exception = exception;
    }

    public static AsyncCallResult createOk() {
        return new AsyncCallResult(null);
    }

    public Exception getException() {
        return exception;
    }

    public boolean isOk() {
        return exception == null;
    }

    public boolean isNotOk() {
        return !isOk();
    }
}