/*
 * ----------------------------------------------------------------
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.api;

import java.time.Duration;

public class ResilienceConfig {
    public static final ResilienceConfig NONE = new ResilienceConfig(0, Duration.ZERO);
    private int numOfRetries;
    private Duration retryInterval;

    protected ResilienceConfig(int numOfRetries, Duration retryInterval) {
        this.numOfRetries = numOfRetries;
        this.retryInterval = retryInterval;
    }

    public int getNumOfRetries() {
        return numOfRetries;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }

    public static ResilienceConfigBuilder builder() {
        return new ResilienceConfigBuilder();
    }

    public static final class ResilienceConfigBuilder {
        private int numOfRetries;
        private Duration retryInterval;

        private ResilienceConfigBuilder() {
        }

        public ResilienceConfigBuilder numOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        public ResilienceConfigBuilder retryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public ResilienceConfig build() {
            return new ResilienceConfig(numOfRetries, retryInterval);
        }
    }
}
