/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.api;

import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.impl.SupplierWithException;

import java.util.List;
import java.util.Map;

public interface ServiceCallMediators {
    /*
    create|http | get   | payload        |pathParameter   |-->| query     |-->|authenticationTokenSupplier| -->|------------------>| end
          |     | put   | withoutPayload | noPathParameter|   | noQuery   |   |withoutAuthentication      |    |insertHeaderFields |
                | post  |                                                     |authenticationToken        |
                | delete|
                | patch |
    */
    public interface FromCreate {
        FromHttp http();
    }

    public interface FromHttp {
        FromHttpMethod get();

        FromHttpMethod put();

        FromHttpMethod post();

        FromHttpMethod delete();

        FromHttpMethod patch();
    }

    public interface FromHttpMethod {
        <P> FromPayload payload(P payload);

        FromPayload withoutPayload();
    }

    public interface FromPayload {
        FromPathParameter pathParameter(String path);

        FromPathParameter noPathParameter();
    }

    public interface FromPathParameter {
        FromQuery query(List<QueryParameter> queryParameters);

        FromQuery noQuery();
    }


    public interface FromQuery {
        FromAuthenticate authenticationTokenSupplier(SupplierWithException<String> authenticationTokenSupplier);

        FromAuthenticate authenticationToken(String token);

        FromAuthenticate withoutAuthentication();
    }

    public interface FromAuthenticate extends End {
        End insertHeaderFields(Map<String, String> headerFields);
    }

    public interface End {
        ServiceCall end() throws InternalException;
    }
}

