/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.api;

import com.sap.cloud.mt.tools.exception.InternalException;

import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;

/**
 * Define syntax of fluent API to create a service endpoint
 */

public interface ServiceEndpointMediators {
    /*
         at -> destinationName         -> path ->   |---> |returnCodeChecker            | ->|retry -> forReturnCodes-> times -> waitBetween -> end
                                                                                                                                                    |
                                                                                                        V--------------------------------------------
                                                                                                    |retryAuthenticationTokenDetermination -> forExceptions -> times -> waitBetween-> end
                                                                                                       |
                                                          |throwNoExceptionForReturnCode|   |noRetry -> end
     */

    public static interface FromCreate {
        FromAt at(String baseUrl);
    }

    public interface FromAt {
        FromDestination destinationName(String destinationName);
    }

    public interface FromDestination {
        FromPath path(String path);
    }

    public interface FromPath {
        FromCodeChecker returnCodeChecker(IntFunction<Exception> checkFunction);

        FromCodeChecker throwNoExceptionForReturnCode();
    }

    public interface FromCodeChecker {
        FromRetry retry();

        FromDoNotRetry doNotRetry();
    }

    public interface FromDoNotRetry extends End, RetryAuthenticationTokenDetermination {

    }

    public interface FromAuthTokenRetry {
        FromReturnCodesOrExceptions forExceptions(Set<Class<? extends Throwable>> returnCodes);

        FromReturnCodesOrExceptions forExceptions(List<Class<? extends Throwable>> returnCodes);

        FromReturnCodesOrExceptions forExceptions(Class<? extends Throwable>... returnCodes);
    }

    public interface FromRetry {
        FromReturnCodesOrExceptions forReturnCodes(Set<Integer> returnCodes);

        FromReturnCodesOrExceptions forReturnCodes(List<Integer> returnCodes);

        FromReturnCodesOrExceptions forReturnCodes(Integer... returnCodes);

    }

    public interface FromReturnCodesOrExceptions {
        FromConfig config(ResilienceConfig config);
    }

    public interface FromConfig extends End, RetryAuthenticationTokenDetermination {
    }

    public interface RetryAuthenticationTokenDetermination {
        FromAuthTokenRetry retryAuthenticationTokenDetermination();
    }

    public interface End {
        ServiceEndpoint end() throws InternalException;
    }

}
