/*
 * ----------------------------------------------------------------
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.impl;

import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;

import java.util.concurrent.ConcurrentHashMap;

public class ServiceDestinations {
    private static final ConcurrentHashMap<String, HttpDestination> serviceToDestination = new ConcurrentHashMap<>();

    private ServiceDestinations() {
    }


    public static HttpDestination getDestination(String destinationName, String url) {
        if (serviceToDestination.contains(destinationName)) {
            return serviceToDestination.get(destinationName);
        }
        return serviceToDestination.computeIfAbsent(destinationName, d -> getDestinationFromCloudSDK(d, url));
    }

    private static HttpDestination getDestinationFromCloudSDK(String destinationName, String url) {
        try {
            return DestinationAccessor.getDestination(destinationName).asHttp();
        } catch (DestinationAccessException e) {
            return DefaultHttpDestination.builder(url).name(destinationName).build();
        }
    }
}
