/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.tools.api;

import com.sap.cloud.mt.tools.api.ResilienceConfig;
import com.sap.cloud.mt.tools.api.ResponseChecker;
import com.sap.cloud.mt.tools.api.ServiceCallMediators;
import com.sap.cloud.mt.tools.api.ServiceEndpointMediators;
import com.sap.cloud.mt.tools.exception.InternalException;
import com.sap.cloud.mt.tools.impl.ServiceCallBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ServiceEndpoint {
    private final String destinationName;
    private final String path;
    private final ResilienceConfig resilienceConfig;
    private final ResponseChecker responseChecker;

    private ServiceEndpoint(String destinationName, String path, ResilienceConfig resilienceConfig, ResponseChecker responseChecker) {
        this.destinationName = destinationName;
        this.path = path;
        this.resilienceConfig = resilienceConfig;
        this.responseChecker = responseChecker;
    }

    public static ServiceEndpointMediators.FromCreate create() {
        return ServiceEndpointBuilder.createBuilder();
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getPath() {
        return this.path;
    }

    public ResilienceConfig getResilienceConfig() {
        return this.resilienceConfig;
    }

    public ResponseChecker getResponseChecker() {
        return this.responseChecker;
    }

    public ServiceCallMediators.FromCreate createServiceCall() {
        return ServiceCallBuilder.createBuilder(this);
    }

    public static class ServiceEndpointBuilder
    implements ServiceEndpointMediators.FromCreate,
    ServiceEndpointMediators.FromDestinationName,
    ServiceEndpointMediators.FromPath,
    ServiceEndpointMediators.FromCodeChecker,
    ServiceEndpointMediators.FromRetry,
    ServiceEndpointMediators.FromReturnCodes,
    ServiceEndpointMediators.FromConfig,
    ServiceEndpointMediators.FromDoNotRetry,
    ServiceEndpointMediators.End {
        private Optional<String> destinationName = Optional.empty();
        private Optional<String> path = Optional.empty();
        private ResilienceConfig resilienceConfigService = ResilienceConfig.NONE;
        private Optional<IntFunction<Exception>> checkFunction = Optional.empty();
        private Set<Integer> returnCodesForRetry = new HashSet<Integer>();

        private ServiceEndpointBuilder() {
        }

        public static ServiceEndpointMediators.FromCreate createBuilder() {
            return new ServiceEndpointBuilder();
        }

        private static ResponseChecker createResponseChecker(IntFunction<Exception> checkFunction, Set<Integer> returnCodesForRetry) {
            return code -> {
                Exception exception = (Exception)checkFunction.apply(code);
                if (returnCodesForRetry.contains(code)) {
                    return new ResponseChecker.CheckResult(exception, true);
                }
                if (exception != null) {
                    return new ResponseChecker.CheckResult(exception, false);
                }
                return ResponseChecker.CheckResult.NO_PROBLEM;
            };
        }

        @Override
        public ServiceEndpointMediators.FromDestinationName destinationName(String destinationName) {
            this.destinationName = Optional.ofNullable(destinationName);
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromPath path(String path) {
            this.path = Optional.ofNullable(path);
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromCodeChecker returnCodeChecker(IntFunction<Exception> checkFunction) {
            this.checkFunction = Optional.ofNullable(checkFunction);
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromCodeChecker throwNoExceptionForReturnCode() {
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromRetry retry() {
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromDoNotRetry doNotRetry() {
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromReturnCodes forReturnCodes(Set<Integer> returnCodes) {
            if (returnCodes != null) {
                this.returnCodesForRetry.addAll(returnCodes);
            }
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromReturnCodes forReturnCodes(List<Integer> returnCodes) {
            if (returnCodes != null) {
                this.returnCodesForRetry.addAll(returnCodes);
            }
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromReturnCodes forReturnCodes(Integer ... returnCodes) {
            ((Stream)Arrays.stream(returnCodes).sequential()).forEach(this.returnCodesForRetry::add);
            return this;
        }

        @Override
        public ServiceEndpointMediators.FromConfig config(ResilienceConfig resilienceConfig) {
            if (resilienceConfig != null) {
                this.resilienceConfigService = resilienceConfig;
            }
            return this;
        }

        @Override
        public ServiceEndpoint end() throws InternalException {
            ResponseChecker responseChecker;
            this.checkParameters();
            if (!this.checkFunction.isPresent() && this.returnCodesForRetry.isEmpty()) {
                responseChecker = ResponseChecker.NONE;
            } else {
                if (!this.checkFunction.isPresent()) {
                    this.checkFunction = Optional.of(code -> null);
                }
                responseChecker = ServiceEndpointBuilder.createResponseChecker(this.checkFunction.get(), this.returnCodesForRetry);
            }
            return new ServiceEndpoint(this.destinationName.get(), this.path.get(), this.resilienceConfigService, responseChecker);
        }

        private void checkParameters() throws InternalException {
            if (!this.destinationName.isPresent() || StringUtils.isEmpty((CharSequence)this.destinationName.get())) {
                throw new InternalException("No service destination name set");
            }
            if (!this.path.isPresent() || StringUtils.isEmpty((CharSequence)this.path.get())) {
                throw new InternalException("No service path set");
            }
        }
    }
}

