/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */
package com.sap.cds.mtx.impl;

import java.io.IOException;
import java.util.Optional;

public interface Authenticator {

    /**
     * @return value of the authorization header or {@code Optional.empty} if no
     * authorization is required
     * @throws IOException thrown if communication with XSUAA service fails
     */
    Optional<String> getAuthorization() throws IOException;

    Authenticator NONE = Optional::empty;
}
