/*
 * ----------------------------------------------------------------
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.api;

public class UuidChecker {
    private static final String DIGIT_OR_CHAR = "[0-9a-fA-F]";
    private static final String GUID_REGEX = "^" + DIGIT_OR_CHAR + "{8}-(" + DIGIT_OR_CHAR + "{4}-){3}" + DIGIT_OR_CHAR + "{12}$";

    private UuidChecker() {
    }

    public static boolean isUUId(String uuid) {
        if (uuid == null) {
            return false;
        }
        return uuid.matches(GUID_REGEX);
    }

}
