/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.exception;

import com.sap.cloud.mt.tools.api.ServiceResponse;

public class ServiceException extends Exception {
    private ServiceResponse<?> response;

    public ServiceException(ServiceResponse<?> response) {
        this.response = response;
    }

    public ServiceException(String message, ServiceResponse<?> response) {
        super(message);
        this.response = response;
    }

    public ServiceException(String message, Throwable cause, ServiceResponse<?> response) {
        super(message, cause);
        this.response = response;
    }

    public ServiceException(Throwable cause, ServiceResponse<?> response) {
        super(cause);
        this.response = response;
    }

    public ServiceResponse<?> getResponse() {
        return response;
    }
}
