/*
 * ----------------------------------------------------------------
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved.
 * ----------------------------------------------------------------
 *
 */

package com.sap.cloud.mt.tools.impl;

import com.sap.cloud.mt.tools.api.ServiceResponse;

public class RetryException extends Exception {
    private final ServiceResponse<?> response;

    public RetryException(ServiceResponse<?> response) {
        this.response = response;
    }

    public RetryException(String message, ServiceResponse<?> response) {
        super(message);
        this.response = response;
    }

    public RetryException(String message, Throwable cause, ServiceResponse<?> response) {
        super(message, cause);
        this.response = response;
    }

    public RetryException(Throwable cause, ServiceResponse<?> response) {
        super(cause);
        this.response = response;
    }

    public ServiceResponse<?> getResponse() {
        return response;
    }
}
