/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.tools.api;

import java.time.Duration;
import java.util.function.BooleanSupplier;

public class ResilienceConfig {
    public static final ResilienceConfig NONE = new ResilienceConfig(0, Duration.ZERO);
    private int numOfRetries;
    private Duration retryInterval;

    public ResilienceConfig() {
    }

    protected ResilienceConfig(int numOfRetries, Duration retryInterval) {
        this.numOfRetries = numOfRetries;
        this.retryInterval = retryInterval;
    }

    public int getNumOfRetries() {
        return this.numOfRetries;
    }

    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }

    public static ResilienceConfigBuilder builder() {
        return new ResilienceConfigBuilder();
    }

    public boolean waitFor(BooleanSupplier finished) {
        if (finished.getAsBoolean()) {
            return true;
        }
        for (int i = 0; i < this.numOfRetries; ++i) {
            ResilienceConfig.waitSomeTime(this.retryInterval);
            if (!finished.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    private static void waitSomeTime(Duration waitTime) {
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static final class ResilienceConfigBuilder {
        private int numOfRetries;
        private Duration retryInterval;

        private ResilienceConfigBuilder() {
        }

        public ResilienceConfigBuilder numOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        public ResilienceConfigBuilder retryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public ResilienceConfig build() {
            return new ResilienceConfig(this.numOfRetries, this.retryInterval);
        }
    }
}

