/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.mtx.impl;

import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cloud.security.client.DefaultHttpClientFactory;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.client.DefaultOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import java.io.IOException;
import java.time.Instant;

public class ClientCredentialJwtReader {
    private final XsuaaTokenFlows tokenFlows;

    public ClientCredentialJwtReader(XsuaaParams xsuaaParams) {
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = xsuaaParams.getOAuth2ServiceConfiguration();
        DefaultHttpClientFactory clientFactory = new DefaultHttpClientFactory();
        this.tokenFlows = new XsuaaTokenFlows((OAuth2TokenService)new DefaultOAuth2TokenService(clientFactory.createClient(oAuth2ServiceConfiguration.getClientIdentity())), (OAuth2ServiceEndpointsProvider)new XsuaaDefaultEndpoints(oAuth2ServiceConfiguration), oAuth2ServiceConfiguration.getClientIdentity());
    }

    public Response getJwt() throws IOException {
        try {
            OAuth2TokenResponse response = this.tokenFlows.clientCredentialsTokenFlow().execute();
            return new Response(response.getExpiredAt(), response.getAccessToken());
        }
        catch (TokenFlowException e) {
            throw new IOException("Could not retrieve JWT.", e);
        }
    }

    public static class Response {
        private final Instant expiredAt;
        private final String accessToken;

        public Response(Instant expiredAt, String accessToken) {
            this.expiredAt = expiredAt;
            this.accessToken = accessToken;
        }

        public boolean isValid() {
            return Instant.now().isBefore(this.expiredAt);
        }

        public String getAccessToken() {
            return this.accessToken;
        }
    }
}

