/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.mt.tools.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.tools.api.HttpMethod;
import com.sap.cloud.mt.tools.api.QueryParameter;
import com.sap.cloud.mt.tools.api.RequestEnhancer;
import com.sap.cloud.mt.tools.api.ResponseChecker;
import com.sap.cloud.mt.tools.api.ServiceCall;
import com.sap.cloud.mt.tools.api.ServiceEndpoint;
import com.sap.cloud.mt.tools.api.ServiceResponse;
import com.sap.cloud.mt.tools.exception.ServiceException;
import com.sap.cloud.mt.tools.impl.NoRetryException;
import com.sap.cloud.mt.tools.impl.Retry;
import com.sap.cloud.mt.tools.impl.RetryException;
import com.sap.cloud.mt.tools.impl.ServiceDestinations;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallImpl
implements ServiceCall {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCallImpl.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String SLASH = "/";
    public static final String RETRY_AFTER = "Retry-After";
    private final ServiceEndpoint serviceEndpoint;
    private final String pathParameter;
    private final Map<String, String> headerFields = new HashMap<String, String>();
    private final List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
    private final Object payload;
    private final RequestEnhancer requestEnhancer;
    private final HttpMethod httpMethod;
    private final ObjectMapper objectMapper;

    protected ServiceCallImpl(HttpMethod httpMethod, ServiceEndpoint serviceEndpoint, String pathParameter, Object payload, Map<String, String> headerFields, List<QueryParameter> queryParameters, RequestEnhancer requestEnhancer) {
        this.httpMethod = httpMethod;
        this.serviceEndpoint = serviceEndpoint;
        this.pathParameter = pathParameter;
        this.payload = payload;
        if (headerFields != null) {
            this.headerFields.putAll(headerFields);
        }
        if (queryParameters != null) {
            this.queryParameters.addAll(queryParameters);
        }
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.requestEnhancer = requestEnhancer;
    }

    @Override
    public <R> ServiceResponse<R> execute(Class<R> responseType) throws ServiceException {
        return this.execute(this.httpMethod, responseType);
    }

    @Override
    public ServiceResponse<Void> execute() throws ServiceException {
        return this.execute(this.httpMethod, Void.class);
    }

    private <R> ServiceResponse<R> execute(HttpMethod method, Class<R> responseType) throws ServiceException {
        RequestBuilder requestBuilder = this.getRequestBuilder(method, this.serviceEndpoint.getPath(), this.pathParameter).setHeader("Content-Type", APPLICATION_JSON);
        this.queryParameters.forEach(queryParameter -> requestBuilder.addParameter(queryParameter.getName(), queryParameter.getValue()));
        if (this.payload != null) {
            requestBuilder.setEntity(this.asEntity(this.payload));
        }
        HttpUriRequest request = requestBuilder.build();
        this.enhanceRequest(request);
        this.headerFields.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        Retry retryServiceCall = Retry.RetryBuilder.create().retryExceptions(RetryException.class).numOfRetries(this.serviceEndpoint.getResilienceConfig().getNumOfRetries()).baseWaitTime(this.serviceEndpoint.getResilienceConfig().getBaseWaitTime()).waitTimeFunction(this.serviceEndpoint.getResilienceConfig().getWaitTimeFunction()).build();
        try {
            return retryServiceCall.execute(() -> this.execute(request, responseType, this.serviceEndpoint.getResponseChecker()));
        }
        catch (Exception exception) {
            RetryException retryException = this.determineException(exception, RetryException.class);
            NoRetryException noRetryException = this.determineException(exception, NoRetryException.class);
            if (retryException != null) {
                if (retryException.getCause() == null) {
                    return retryException.getResponse();
                }
                throw new ServiceException(retryException.getCause(), retryException.getResponse());
            }
            if (noRetryException != null) {
                throw new ServiceException(noRetryException.getCause(), noRetryException.getResponse());
            }
            throw new RuntimeException("Wrong exception type");
        }
    }

    private void enhanceRequest(HttpUriRequest request) throws ServiceException {
        if (this.requestEnhancer != null) {
            try {
                this.requestEnhancer.enhance(request);
            }
            catch (Exception e) {
                throw new ServiceException(e, null);
            }
        }
    }

    private RequestBuilder getRequestBuilder(HttpMethod method, String path, String pathParameter) throws ServiceException {
        switch (method) {
            case GET: {
                return RequestBuilder.get((String)this.getTotalPath(path, pathParameter));
            }
            case PUT: {
                return RequestBuilder.put((String)this.getTotalPath(path, pathParameter));
            }
            case POST: {
                return RequestBuilder.post((String)this.getTotalPath(path, pathParameter));
            }
            case DELETE: {
                return RequestBuilder.delete((String)this.getTotalPath(path, pathParameter));
            }
            case PATCH: {
                return RequestBuilder.patch((String)this.getTotalPath(path, pathParameter));
            }
        }
        throw new ServiceException("Http method " + method.name() + " not known", null);
    }

    private String getTotalPath(String path, String pathParameter) {
        StringBuilder pathBuilder = new StringBuilder(path);
        if (StringUtils.isNotBlank((CharSequence)pathParameter)) {
            String adjustedPathParameter = pathParameter;
            if (pathParameter.startsWith(SLASH)) {
                adjustedPathParameter = pathParameter.length() == 1 ? "" : pathParameter.substring(1);
            }
            if (!path.endsWith(SLASH)) {
                pathBuilder.append(SLASH);
            }
            pathBuilder.append(adjustedPathParameter);
        }
        return pathBuilder.toString();
    }

    private <R> ServiceResponse<R> execute(HttpUriRequest request, Class<R> responseType, ResponseChecker responseChecker) throws RetryException, NoRetryException {
        ServiceResponse<R> serviceResponse = new ServiceResponse<R>();
        try {
            HttpDestination destination = this.serviceEndpoint.getDestination() != null ? this.serviceEndpoint.getDestination() : ServiceDestinations.getDestination(this.serviceEndpoint.getDestinationName());
            HttpClient client = HttpClientAccessor.getHttpClient((HttpDestinationProperties)destination);
            logger.debug("Service {} is called with url {} and path {}", new Object[]{this.serviceEndpoint.getDestinationName(), destination.getUri(), request.getURI()});
            try (CloseableHttpResponse response = (CloseableHttpResponse)client.execute(request);){
                int responseCode = response.getStatusLine().getStatusCode();
                serviceResponse.setHttpStatusCode(responseCode);
                serviceResponse.setHeaders(response.getAllHeaders());
                String returnedPayloadAsString = "";
                if (response.getEntity() != null && responseType != Void.class) {
                    returnedPayloadAsString = EntityUtils.toString((HttpEntity)response.getEntity());
                    serviceResponse.setPayload(Optional.ofNullable(this.asResultType(returnedPayloadAsString, responseType)));
                }
                if (response.containsHeader("ETag")) {
                    serviceResponse.setETag(Optional.of(response.getLastHeader("ETag").getValue()));
                }
                ResponseChecker.CheckResult checkResult = responseChecker.checkCode(responseCode);
                Optional<Exception> exception = checkResult.getException();
                if (checkResult.isTemporaryProblem()) {
                    logger.debug("A temporary problem was detected. Service call returned with code {}", (Object)responseCode);
                    if (StringUtils.isNotEmpty((CharSequence)returnedPayloadAsString)) {
                        logger.debug("Service {} was called with url {} and path {} and returned payload {}", new Object[]{this.serviceEndpoint.getDestinationName(), destination.getUri(), request.getURI(), returnedPayloadAsString});
                    }
                    Duration requestedWaitTime = this.getRequestedWaitTime(responseCode, response);
                    if (exception.isPresent()) {
                        throw new RetryException(exception.get(), serviceResponse, requestedWaitTime);
                    }
                    throw new RetryException(serviceResponse, requestedWaitTime);
                }
                if (exception.isPresent()) {
                    logger.error("A non temporary problem was detected. Service call returned with code {}", (Object)responseCode);
                    if (StringUtils.isNotEmpty((CharSequence)returnedPayloadAsString)) {
                        logger.debug("Service {} was called with url {} and path {} and returned payload {}", new Object[]{this.serviceEndpoint.getDestinationName(), destination.getUri(), request.getURI(), returnedPayloadAsString});
                    }
                    throw new NoRetryException(exception.get(), serviceResponse);
                }
            }
        }
        catch (NoRetryException | RetryException exception) {
            throw exception;
        }
        catch (IOException ioException) {
            throw new RetryException(ioException, serviceResponse, null);
        }
        catch (Exception e) {
            throw new NoRetryException(e, serviceResponse);
        }
        return serviceResponse;
    }

    private Duration getRequestedWaitTime(int responseCode, CloseableHttpResponse response) {
        String retryAfterStr;
        Duration requestedWaitTime = null;
        if (responseCode == 429 && response.containsHeader(RETRY_AFTER) && (requestedWaitTime = this.getWaitTimeFromDateTime(retryAfterStr = response.getFirstHeader(RETRY_AFTER).getValue())) == null) {
            requestedWaitTime = ServiceCallImpl.getRequestedWaitTimeFromInt(retryAfterStr);
        }
        return requestedWaitTime;
    }

    private static Duration getRequestedWaitTimeFromInt(String retryAfterStr) {
        try {
            return Duration.ofSeconds(Integer.parseInt(retryAfterStr));
        }
        catch (NumberFormatException e) {
            logger.debug("Wait time isn't specified as seconds", (Throwable)e);
            return null;
        }
    }

    private Duration getWaitTimeFromDateTime(String dateTime) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.US);
            ZonedDateTime retryAfterDateTime = ZonedDateTime.parse(dateTime, formatter);
            ZonedDateTime now = ZonedDateTime.now(retryAfterDateTime.getZone());
            if (retryAfterDateTime.isBefore(now)) {
                return Duration.ofMillis(1L);
            }
            return Duration.between(now, retryAfterDateTime);
        }
        catch (DateTimeParseException e) {
            logger.debug("Wait time isn't specified as date-time ", (Throwable)e);
            return null;
        }
    }

    private <R> R asResultType(String payload, Class<R> responseType) {
        if (StringUtils.isEmpty((CharSequence)payload)) {
            payload = "{}";
        }
        if (responseType == String.class) {
            return (R)payload;
        }
        try {
            return (R)this.objectMapper.readValue(payload, responseType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private HttpEntity asEntity(Object payload) throws ServiceException {
        try {
            if (payload instanceof String) {
                return new StringEntity((String)payload);
            }
            return new StringEntity(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(payload));
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            throw new ServiceException(e, null);
        }
    }

    <T extends Exception> T determineException(Exception exception, Class<T> exceptionClass) {
        Exception resultException = null;
        if (exceptionClass.isInstance(exception)) {
            resultException = exception;
        } else if (exceptionClass.isInstance(exception.getCause())) {
            resultException = (Exception)exception.getCause();
        }
        return (T)resultException;
    }
}

