/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco;

public class JCoException
extends Exception {
    static final long serialVersionUID = 20050909001L;
    public static final int JCO_ERROR_PROGRAM = 101;
    public static final int JCO_ERROR_CONFIGURATION = 101;
    public static final int JCO_ERROR_COMMUNICATION = 102;
    public static final int JCO_ERROR_LOGON_FAILURE = 103;
    public static final int JCO_ERROR_SYSTEM_FAILURE = 104;
    public static final int JCO_ERROR_APPLICATION_EXCEPTION = 105;
    public static final int JCO_ERROR_RESOURCE = 106;
    public static final int JCO_ERROR_PROTOCOL = 107;
    public static final int JCO_ERROR_INTERNAL = 108;
    public static final int JCO_ERROR_CANCELLED = 109;
    public static final int JCO_ERROR_STATE_BUSY = 110;
    public static final int JCO_ERROR_ABAP_CLASS_EXCEPTION = 111;
    public static final int JCO_ERROR_REQUEST_CANCELLED = 112;
    public static final int JCO_ERROR_REGISTRATION_DENIED = 113;
    public static final int JCO_ERROR_EXTENSION = 120;
    public static final int JCO_ERROR_NULL_HANDLE = 121;
    public static final int JCO_ERROR_CONVERSION = 122;
    public static final int JCO_ERROR_FUNCTION_NOT_FOUND = 123;
    public static final int JCO_ERROR_ILLEGAL_TID = 124;
    public static final int JCO_ERROR_UNSUPPORTED_CODEPAGE = 125;
    public static final int JCO_ERROR_ABAP_EXCEPTION = 126;
    public static final int JCO_ERROR_FIELD_NOT_FOUND = 127;
    public static final int JCO_ERROR_NOT_SUPPORTED = 128;
    public static final int JCO_ERROR_SERVER_STARTUP = 129;
    public static final int JCO_ERROR_XML_PARSER = 130;
    public static final int JCO_ERROR_ILLEGAL_ARGUMENT = 131;
    public static final int JCO_ERROR_CONCURRENT_CALL = 132;
    public static final int JCO_ERROR_INVALID_HANDLE = 133;
    public static final int JCO_ERROR_INITIALIZATION = 134;
    public static final int JCO_ERROR_TIMEOUT = 135;
    public static final int JCO_ERROR_ILLEGAL_STATE = 136;
    public static final int JCO_ERROR_PASSWORD_CHANGE_REQUIRED = 138;
    public static final int JCO_ERROR_DSR_LOAD_ERROR = 150;
    public static final int JCO_ERROR_SESSION_REF_NOT_VALID = 153;
    public static final int JCO_ERROR_JARM_LOAD_ERROR = 155;
    public static final int JCO_ERROR_DATA_PROVIDER_ERROR = 156;
    public static final int JCO_ERROR_SHAREABLE_CONTAINER = 160;
    public static final int JCO_ERROR_CREATE_SESSION = 170;
    public static final int JCO_ERROR_PASSIVATE_SESSION = 171;
    public static final int JCO_ERROR_RESTORE_SESSION = 172;
    public static final int JCO_ERROR_DESTROY_SESSION = 173;
    public static final int JCO_ERROR_DESTINATION_DATA_INVALID = 180;
    public static final int JCO_ERROR_SERVER_DATA_INVALID = 181;
    public static final int JCO_ERROR_INVALID_REPOSITORY_CACHE = 190;
    public static final int JCO_ERROR_REPOSITORY_SERIALIZATION = 191;
    private int group;
    private String key;
    private String remoteSystemInfo;
    private String messageClass;
    private char messageType;
    private String messageNumber;
    private String[] messageParameters;

    static String getKeyForGroup(int group) {
        switch (group) {
            case 101: {
                return "JCO_ERROR_CONFIGURATION";
            }
            case 102: {
                return "JCO_ERROR_COMMUNICATION";
            }
            case 103: {
                return "JCO_ERROR_LOGON_FAILURE";
            }
            case 104: {
                return "JCO_ERROR_SYSTEM_FAILURE";
            }
            case 105: {
                return "JCO_ERROR_APPLICATION_EXCEPTION";
            }
            case 106: {
                return "JCO_ERROR_RESOURCE";
            }
            case 107: {
                return "JCO_ERROR_PROTOCOL";
            }
            case 108: {
                return "JCO_ERROR_INTERNAL";
            }
            case 109: {
                return "JCO_ERROR_CANCELLED";
            }
            case 110: {
                return "JCO_ERROR_STATE_BUSY";
            }
            case 111: {
                return "JCO_ERROR_ABAP_CLASS_EXCEPTION";
            }
            case 112: {
                return "JCO_ERROR_REQUEST_CANCELLED";
            }
            case 113: {
                return "JCO_ERROR_REGISTRATION_DENIED";
            }
            case 120: {
                return "JCO_ERROR_EXTENSION";
            }
            case 121: {
                return "JCO_ERROR_NULL_HANDLE";
            }
            case 122: {
                return "JCO_ERROR_CONVERSION";
            }
            case 123: {
                return "JCO_ERROR_FUNCTION_NOT_FOUND";
            }
            case 124: {
                return "JCO_ERROR_ILLEGAL_TID";
            }
            case 125: {
                return "JCO_ERROR_UNSUPPORTED_CODEPAGE";
            }
            case 126: {
                return "JCO_ERROR_ABAP_EXCEPTION";
            }
            case 127: {
                return "JCO_ERROR_FIELD_NOT_FOUND";
            }
            case 128: {
                return "JCO_ERROR_NOT_SUPPORTED";
            }
            case 129: {
                return "JCO_ERROR_SERVER_STARTUP";
            }
            case 130: {
                return "JCO_ERROR_XML_PARSER";
            }
            case 131: {
                return "JCO_ERROR_ILLEGAL_ARGUMENT";
            }
            case 132: {
                return "JCO_ERROR_CONCURRENT_CALL";
            }
            case 133: {
                return "JCO_ERROR_INVALID_HANDLE";
            }
            case 134: {
                return "JCO_ERROR_INITIALIZATION";
            }
            case 135: {
                return "JCO_ERROR_TIMEOUT";
            }
            case 136: {
                return "JCO_ERROR_ILLEGAL_STATE";
            }
            case 150: {
                return "JCO_ERROR_DSR_LOAD_ERROR";
            }
            case 153: {
                return "JCO_ERROR_SESSION_REF_NOT_VALID";
            }
            case 155: {
                return "JCO_ERROR_JARM_LOAD_ERROR";
            }
            case 160: {
                return "JCO_ERROR_SHAREABLE_CONTAINER";
            }
            case 170: {
                return "JCO_ERROR_CREATE_SESSION";
            }
            case 171: {
                return "JCO_ERROR_PASSIVATE_SESSION";
            }
            case 172: {
                return "JCO_ERROR_RESTORE_SESSION";
            }
            case 180: {
                return "JCO_ERROR_DESTINATION_DATA_INVALID";
            }
            case 181: {
                return "JCO_ERROR_SERVER_DATA_INVALID";
            }
            case 138: {
                return "JCO_ERROR_PASSWORD_CHANGE_REQUIRED";
            }
            case 156: {
                return "JCO_ERROR_DATA_PROVIDER_ERROR";
            }
            case 190: {
                return "JCO_ERROR_INVALID_REPOSITORY_CACHE";
            }
            case 191: {
                return "JCO_ERROR_REPOSITORY_SERIALIZATION";
            }
        }
        return "JCO_UNKNOWN_GROUP_" + group;
    }

    public JCoException(int group, String key, String message) {
        this(group, key, message, null, '\u0000', null, null, null, null);
    }

    public JCoException(int group, String message) {
        this(group, JCoException.getKeyForGroup(group), message, null, '\u0000', null, null, null, null);
    }

    public JCoException(int group, String key, String message, Throwable cause) {
        this(group, key, message, null, '\u0000', null, null, cause, null);
    }

    public JCoException(int group, String message, Throwable cause) {
        this(group, JCoException.getKeyForGroup(group), message, null, '\u0000', null, null, cause, null);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters) {
        this(group, key, message, messageClass, messageType, messageNumber, messageParameters, null, null);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters, Throwable cause) {
        this(group, key, message, messageClass, messageType, messageNumber, messageParameters, cause, null);
    }

    public JCoException(int group, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters, Throwable cause, String raisedBy) {
        this(group, JCoException.getKeyForGroup(group), message, messageClass, messageType, messageNumber, messageParameters, cause, raisedBy);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters, Throwable cause, String raisedBy) {
        super(message, cause);
        this.key = key;
        this.group = group;
        this.messageClass = messageClass;
        this.messageType = messageType;
        this.messageNumber = messageNumber;
        if (messageParameters != null) {
            this.messageParameters = new String[4];
            System.arraycopy(messageParameters, 0, this.messageParameters, 0, Math.min(messageParameters.length, this.messageParameters.length));
        }
        this.remoteSystemInfo = raisedBy;
    }

    public final int getGroup() {
        return this.group;
    }

    public final String getKey() {
        return this.key;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public String getMessageText() {
        if (this.messageParameters != null) {
            StringBuffer buf = new StringBuffer(256);
            for (int i = 0; i < this.messageParameters.length; ++i) {
                if (this.messageParameters[i] == null) continue;
                buf.append(this.messageParameters[i]);
            }
            return buf.toString();
        }
        return null;
    }

    public String getMessageParameter(int index) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException("Message parameter " + index + " is not available. Valid range is 0-3");
        }
        if (this.messageParameters != null) {
            return this.messageParameters[index];
        }
        return null;
    }

    public String[] getMessageParameters() {
        if (this.messageParameters != null) {
            String[] returnMessageParameters = new String[4];
            System.arraycopy(this.messageParameters, 0, returnMessageParameters, 0, 4);
            return returnMessageParameters;
        }
        return null;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append(": (").append(this.group).append(") ");
        buffer.append(this.key).append(": ").append(this.getMessage());
        if (this.messageType == 'X' && "00".equals(this.messageClass) && "341".equals(this.messageNumber)) {
            if (this.messageParameters != null && this.messageParameters[0] != null) {
                buffer.append(" (Remote shortdump: ").append(this.messageParameters[0]);
            }
            if (this.remoteSystemInfo != null) {
                buffer.append(" in system ").append(this.remoteSystemInfo);
            }
            buffer.append(')');
        } else {
            if (this.remoteSystemInfo != null) {
                if (this.group == 104) {
                    buffer.append(" (raised by system ");
                } else {
                    buffer.append(" (remote system is ");
                }
                buffer.append(this.remoteSystemInfo).append(')');
            }
            if (this.messageClass != null) {
                buffer.append(" Message ").append(this.messageNumber).append(" of class ").append(this.messageClass);
                buffer.append(" type ").append(this.messageType);
                for (int i = 0; i < 4; ++i) {
                    if (this.messageParameters[i] == null) continue;
                    buffer.append(", Par[").append(i + 1).append("]: ").append(this.messageParameters[i]);
                }
            }
        }
        return buffer.toString();
    }
}

