/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.server;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.JCoServer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class JCoServerFactoryCF {
    private static final String SERVER_FACTORY_CF = "com.sap.core.connectivity.jco.cf.server.ServerFactoryCFBridge";
    private static JCoServerFactoryCF instance = null;
    private static ClassLoader cl;

    public static synchronized void init(ClassLoader cl) {
        AccessCheck.requireAccess();
        JCoServerFactoryCF.cl = cl;
    }

    private static synchronized JCoServerFactoryCF get() throws JCoException {
        if (instance == null) {
            if (cl == null) {
                throw new JCoException(134, "ClassLoader for " + JCoServerFactoryCF.class.getSimpleName() + " has not been initialized");
            }
            try {
                Class<?> runtimeClass = Class.forName(SERVER_FACTORY_CF, true, cl);
                Method getRuntime = runtimeClass.getMethod("get", new Class[0]);
                instance = (JCoServerFactoryCF)getRuntime.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return instance;
    }

    protected JCoServerFactoryCF() {
    }

    protected abstract JCoServer getServerInstance() throws JCoException;

    public static JCoServer getServer() throws JCoException {
        return JCoServerFactoryCF.get().getServerInstance();
    }

    private static class AccessCheck {
        private static final String CALL_PROHIBITED = "It's not allowed to use com.sap.conn.jco.server.JCoServerFactoryCF.init() from ";
        private static final String[] DEFAULT_ACCEPTED_CALLER_LIST = new String[]{"com.sap.core.connectivity.jco.cf.server.ServerHandlerCF"};
        private static final Set<String> acceptedCallers = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(DEFAULT_ACCEPTED_CALLER_LIST)));
        private static final int INVOCATION_DEPTH_IN_CURRENT_CLASS = 4;
        private static final CallStackSecurityManager securityManagerForCheckingTheCaller = new CallStackSecurityManager();

        private AccessCheck() {
        }

        private static void requireAccess() {
            Class<?>[] classStack = securityManagerForCheckingTheCaller.getCallStack();
            if (classStack != null && classStack.length > 4) {
                String caller = classStack[4].getName();
                if (!acceptedCallers.contains(caller)) {
                    throw new IllegalStateException(CALL_PROHIBITED + caller + ".");
                }
            } else {
                List<Class<?>> callStackList = classStack == null ? null : Arrays.asList(classStack);
                throw new IllegalStateException(CALL_PROHIBITED + callStackList + ".");
            }
        }

        private static class CallStackSecurityManager
        extends SecurityManager {
            private CallStackSecurityManager() {
            }

            public Class<?>[] getCallStack() {
                return this.getClassContext();
            }
        }
    }
}

